' BoxDot for the Colour Maximite 2
'   by vegipete  October 2020
'
'  version 0.3  - first release
'  version 0.4  - much 'smarter'
'
' On a square grid of dots, draw lines to connect dots
' and capture completed squares. Win by capturing more
' than half of the available squares.
'
' The program requires a mouse.
' Adjust the value of 'mouseport' to suit which port your
' mouse is plugged in to.
'
' An enterprising programmer could likely add alternate
' user input routines by modifying the next few lines and
' the two routines at the end of the program.

CONST mouseport = 0   ' change if needed, 0/1/2/3

mode 1,8
cls

' try a few times to find a mouse
for i = 1 to 5
  on error skip
  controller mouse open mouseport, LeftClick
  if MM.ERRNO = 0 then
    exit for
  endif
  pause 100
next i
controller mouse close mouseport

if 5 < i then
  print @(300,300) "Sorry, this program needs a mouse."
  end
endif

mouseshow = 0
GUI CURSOR ON 1,0,0,RGB(RED)
controller mouse open mouseport, LeftClick
settick 20, PeriodicInt   ' mouse pointer update ISR

CONST WHITE = &hFFFFFF
CONST ABOVE = 1
CONST RIGHT = 2
CONST BELOW = 4
CONST LEFT  = 8
CONST SIZEBX = 40

SIZEX = 15  ' start with max size for array dimensions
SIZEY = 11

' table of font heights
dim fh(7) = (0,12,20,24,16,32,50,8)

dim board(SIZEX * SIZEY)
dim boardcopy(SIZEX * SIZEY)  ' for evaluating move quality
dim safe(SIZEX * SIZEY)
dim danger(SIZEX * SIZEY)

dim score(2) = (0,0,0)
dim pcolour(1) = (RGB(YELLOW),RGB(RED))

' make a cursor
page write 1
cls
circle 10,10,9,2,1,rgb(green)
sprite read 1,0,0,20,20
page write 0
cls &h808080

skillevel = 0

y = 100
restore Introduction
do
  read w$
  if w$ <> "DONE" then
    text MM.HRES/2,y,mid$(w$,2),"CT",val(left$(w$,1)),1,,-1
  endif
  y = y + fh(val(left$(w$,1)))
loop until w$ = "DONE"

Introduction:
data "3BOXDOT for the Colour Maximite 2"
data "2"
data "2Welcome to the game of dots and boxes."
data "2"
data "2Your task is to capture more squares than the computer."
data "2Win by taking more than half the squares in the grid."
data "2"
data "2Take turns connecting dots with a single line."
data "2If you draw a line that completes all four sides of a box,"
data "2you capture that box and you get to go again."
data "2"
data "DONE"

do
  SelectGridSize
  cls &h808080
  math set 0, board()
  player = 1 - (score(1) > score(0))  ' winner goes first, computer starts game

  score(0) = 0
  score(1) = 0

  for y = 0 to SIZEY
    for x = 0 to SIZEX
      circle xshift + x*SIZEBX, yshift + y*SIZEBX,6,1,1,0,0
    next x
  next y

  do
    player = 1 - player
    if player = COMPUTER then
      filledboxes = MakeMove(player)
    else
      filledboxes = ChooseMove(player)
    endif
    if filledboxes = SIZEX * SIZEY then exit do
    if HalfTaken() then exit do
  loop
  text 400, 25, "WINNER!","CM",5,1,&h00FFFF,&h808080
  i = Claim3Sides(player)   ' automatically finish any chain
  for i = 1 to 4
    p = 1
    if score(0) > score(1) then p = 0
    text 200+p*400, 25, str$(score(p)),"CM",5,1,pcolour(p),&h808080
    pause 250
    text 200+p*400, 25, str$(score(p)),"CM",5,1,pcolour(p),&h00F000
    pause 500
  next i
loop

end ' should never get here

' draw buttons, let user click one
sub SelectGridSize
  chooselevel = 1
  text MM.HRES/2,485,"Select Grid Size:","CT",2,1,,&h808080

  rbox 154,514,100,75,10,&h404040,&h404040
  rbox 150,510,100,75,10,&hC0C0C0,&hC0C0C0
  text 200,547,"5 x 3","CM",2,1,0,-1

  rbox 274,514,100,75,10,&h404040,&h404040
  rbox 270,510,100,75,10,&hC0C0C0,&hC0C0C0
  text 320,547,"7 x 5","CM",2,1,0,-1

  rbox 394,514,100,75,10,&h404040,&h404040
  rbox 390,510,100,75,10,&hC0C0C0,&hC0C0C0
  text 440,547,"11 x 9","CM",2,1,0,-1

  rbox 514,514,100,75,10,&h404040,&h404040
  rbox 510,510,100,75,10,&hC0C0C0,&hC0C0C0
  text 560,547,"15 x 11","CM",2,1,0,-1

  rbox 634,514,100,75,10,&h404040,&h404040
  rbox 630,510,100,75,10,&hC0C0C0,&hC0C0C0
  text 680,547,"QUIT","CM",2,1,0,-1

  text  20,510,"Difficulty","LM",2,1,,&h808080
  rbox  30,525,20,20,3,&hC0C0C0,&hC0C0C0
  text  60,535,"Easy","LM",2,1,,&h808080
  rbox  30,550,20,20,3,&hC0C0C0,&hC0C0C0
  text  60,560,"Hard","LM",2,1,,&h808080
  if skillevel then
    text  39,560,"X","CM",2,1,&hFF6060,-1  ' show check mark hard
  else
    text  39,535,"X","CM",2,1,&hFF6000,-1  ' show check mark easy
  endif

  do while chooselevel : loop  ' wait for mouse click ISR to get user input

  select case userselect ' what did the user select?
    case 0
      settick 0,0  ' periodic timer ISR off so it doesn't try to move the mouse
      sprite close 1
      gui cursor off
      controller mouse close mouseport
      for i = 1 to MM.VRES
        sprite scroll 0,1,0
      next i
      end
    case 1
      SIZEX = 5
      SIZEY = 3
    case 2
      SIZEX = 7
      SIZEY = 5
    case 3
      SIZEX = 11
      SIZEY = 9
    case 4
      SIZEX = 15
      SIZEY = 11
  end select

  ' top left corner of playing grid
  xshift = (MM.HRES-SIZEX*SIZEBX)/2
  yshift = 50

end sub

' let player select a move, return total number of filled boxes on grid
function ChooseMove(player)
  do
    filled = 0
    playbox = 0
    playside = 0
    mouseshow = 1
    do : loop until playbox   ' wait for mouse click ISR to report player selection
    mouseshow = 0
    sprite show 1,MM.HRES-1,MM.VRES-1,1
    DrawOneSide(playbox,playside,player,0)  ' draw the selected side
    board(playbox) = board(playbox) + playside ' fill in side of box
    if board(playbox) = 15 then
      LabelBox(playbox,player)  ' player just closed box
      filled = 1  ' player gets to play again
    endif
    pbb = BoxBeside(playbox,playside)
    if pbb then   ' is this side part of a neighbour box?
      board(pbb) = board(pbb) + Opposite(playside) ' fill in side of neighbour box
      if board(pbb) = 15 then   ' check for filled
        LabelBox(pbb,player)
        filled = 1  ' player gets to play again
      endif
    endif

    cnt = 0
    for i = 1 to SIZEX * SIZEY
      if board(i) = 15 then cnt = cnt + 1
    next i
    ChooseMove = cnt

  loop until (filled = 0) or (SIZEX * SIZEY = cnt) or HalfTaken()

end function

' Computer will selct a move, return total number of filled boxes on grid
function MakeMove(player)
  local integer cnt
  local integer i,j,k,ns
  local integer boxnum, bb, boxside
  local integer chainlen(2)

  ns = Claim3Sides(player)

  ' test for safe, dangerous and filled boxes (no 3 sided at this point)
  ' note a box can't be safe on a given side if the adjacent box is not safe
  math set 9999, danger()   ' don't really need this
  danger(0) = 0
  math set 9999, safe()   ' don't really need this one either
  safe(0) = 0
  cnt = 0
  for i = 1 to SIZEX * SIZEY
    select case board(i)
      case 15 ' filled
        cnt = cnt + 1
      case 0,1,2,4,8  ' safe (ish) 0 or 1 side filled
        for j = 0 to 3  ' test 4 sides for safe
          boxside = 2^j  ' 1,2,4,8
          if (board(i) and boxside) = 0 then   ' check for empty side
            bb = BoxBeside(i,boxside)
            if bb then  ' is there a box on that side?
              select case board(bb)
                case 0,1,2,4,8    ' these values indicate a safe neighbor box
                  safe(0) = safe(0) + 1
                  safe(safe(0)) = i
                  exit for  ' early exit of for j
              end select
            else  ' no box on that side so it's safe
              safe(0) = safe(0) + 1
              safe(safe(0)) = i
              exit for  ' early exit of for j
            endif
          endif
        next j
        ' we can inore safe boxes with only unsafe naigbours
      case 3,5,6,9,10,12  ' dangerous - 2 sides filled
        danger(0) = danger(0) + 1
        danger(danger(0)) = i
    end select
  next i

  ' early done if all boxes are filled
  if cnt = SIZEX * SIZEY then MakeMove = cnt : exit function

  if safe(0) then
    boxnum = safe(1 + int(rnd * safe(0)))   ' randomly pick a safe box
    do  ' randomly pick sides until a safe blank one is found
      boxside = 2 ^ int(rnd * 4)
      if (board(boxnum) and boxside) = 0 then ' chosen side is blank
        bb = BoxBeside(boxnum,boxside)
        if bb then  ' is there a box on that side?
          select case board(bb)
            case 0,1,2,4,8    ' these values indicate a safe neighbor box
              exit do ' found a safe side
          end select
        else  ' no box on that side so it's safe
          exit do  ' outside edge is safe
        endif
      endif
    loop
  else  ' dangerous move so pick one based on skillevel
    if skillevel then   ' hard so pick least generous move
      chainlen(0) = SIZEX * SIZEY   ' assume worst to begin with
      chainlen(1) = 0
      chainlen(2) = 0
      for i = 1 to danger(0)  ' look through all dangerous boxes
        for boxside = 2 to 4 step 2 ' check right and bottom sides
          'boxside = j '2^j   ' 1,2,4,8
          k = danger(i)
          if k = 1 then   ' top left box needs special treatment
            if (board(k) and 1) = 0 then  ' is top of box 1 empty?
              math scale board(), 1, boardcopy()   ' make backup of game board
              board(k) = board(k) + 1        ' fill in top side
              ns = Claim3Sides(-1)      ' count resulting 3-sided box close chain
              if ns < chainlen(0) then  ' is this result better?
                chainlen(0) = ns        ' yes, so save chain length
                chainlen(1) = k         '  and save box number
                chainlen(2) = 1         '  and save side
              endif
              math scale boardcopy(), 1, board() ' restore game board
            endif
          elseif (board(k) and boxside) = 0 then ' is this side empty?
            math scale board(), 1, boardcopy()   ' make backup of game board
            board(k) = board(k) + boxside        ' fill in this side
            bb = BoxBeside(k,boxside) ' check for and add side to box beside
            if bb then board(bb) = board(bb) + Opposite(boxside)
            ns = Claim3Sides(-1)      ' count resulting 3-sided box close chain
            if ns < chainlen(0) then  ' is this result better?
              chainlen(0) = ns        ' yes, so save chain length
              chainlen(1) = k         '  and save box number
              chainlen(2) = boxside   '  and save side
            endif
            math scale boardcopy(), 1, board() ' restore game board
          endif
        next boxside
      next i

      boxnum = chainlen(1)    ' pick least dangerous box
      boxside = chainlen(2)   ' and least dangerous side
    else    ' easy skill level so pick random
      boxnum = danger(1 + int(rnd * danger(0))) ' randomly pick a dangerous box
      do  ' randomly pick sides until a blank one is found
        boxside = 2 ^ int(rnd * 4)
      loop until (board(boxnum) and boxside) = 0
    endif
  endif

  board(boxnum) = board(boxnum) + boxside ' fill in side of box
  DrawOneSide(boxnum,boxside,player,1)
  bb = BoxBeside(boxnum,boxside)
  if bb then board(bb) = board(bb) + Opposite(boxside)
  if board(bb) = 15 then LabelBox(bb,player)  ' shouldn't happen

  MakeMove = cnt
end function

' test if a player has taken more than half the boxes
function HalfTaken()
  HalfTaken = 0
  if (score(0) > SIZEX*SIZEY/2) or (score(1) > SIZEX*SIZEY/2) then HalfTaken = 1
end function

' Claim all 3 sided boxes, return number of boxes closed
function Claim3Sides(p)
  local i, bside, n

  n = 0
  i = 1
  do    ' find and claim all 3-sided boxes
    bside = Test3Sides(i)   ' test for 3 sided box
    if bside then
      n = n + CloseBox(i,bside,p) ' count closed boxes
      i = 0   ' closed a box so start checking from the beginning again
    endif
    i = i + 1
  loop until i > SIZEX * SIZEY
  Claim3Sides = n
end function

' Test if given box already has 3 sides
' If true, return the open side
' If not true, return 0
function Test3Sides(n)
  select case board(n)
    case 7  ' left side open
      Test3Sides = LEFT
    case 11 ' bottom side open
      Test3Sides = BELOW
    case 13 ' right side open
      Test3Sides = RIGHT
    case 14 ' top side open
      Test3Sides = ABOVE
    case else
      Test3Sides = 0
  end select
end function

' Close given box number, add point to player
' Test for second closed box on other side of line
function CloseBox(boxnum, side, player)
  local beb

  board(boxnum) = 15      ' close the box
  CloseBox = 1
  DrawOneSide(boxnum,side,player,0)
  LabelBox(boxnum,player)
  beb = BoxBeside(boxnum,side)
  if beb then      ' test for adjacent box
    board(beb) = board(beb) + Opposite(side) ' draw line on side of adjacent box
    if board(beb) = 15 then  ' did we also close this box?
      LabelBox(beb,player)
      CloseBox = 2
    endif
  endif
end function

' Is there a box in the given direction?
' Return number of this box, or 0 if none.
function BoxBeside(n, dir)
  local result = 0
  select case dir
    case ABOVE
      if n > SIZEX then result = n - SIZEX
    case RIGHT
      if n MOD SIZEX then result = n + 1
    case BELOW
      if n <= SIZEX * SIZEY - SIZEX then result = n + SIZEX
    case LEFT
      if (n-1) MOD SIZEX then result = n - 1
    case else
      result = 0
  end select
  BoxBeside = result
end function

' Return opposite side value
function Opposite(side)
  select case side
    case ABOVE
      Opposite = BELOW
    case RIGHT
      Opposite = LEFT
    case BELOW
      Opposite = ABOVE
    case LEFT
      Opposite = RIGHT
    case else
      Opposite = 0
  end select
end function

' Calculate x,y coordinates of top-left corner of given box
function xOrg(c)
  xOrg = xshift + (0 + (c-1) MOD SIZEX)*SIZEBX
end function

function yOrg(c)
  yOrg = yshift + (0 + (c-1) \ SIZEX)*SIZEBX
end function

' Draw one side of given box number, blink computer moves to find them
' Draw nothing if p(layer) is negative
sub DrawOneSide(n,side,p,blink)

  if p >= 0 then
    GUI CURSOR HIDE
    for i = 0 to blink * 3
      select case side
        case 1
          line xOrg(n)+6,yOrg(n),xOrg(n)+34,yOrg(n),2,&h808080 ' top line
        case 2
          line xOrg(n)+39,yOrg(n)+6,xOrg(n)+39,yOrg(n)+34,2,&h808080 ' right
        case 4
          line xOrg(n)+6,yOrg(n)+SIZEBX,xOrg(n)+34,yOrg(n)+SIZEBX,2,&h808080 ' bottom
        case 8
          line xOrg(n)-1,yOrg(n)+6,xOrg(n)-1,yOrg(n)+34,2,&h808080 ' left
      end select
      pause 100 * blink
      select case side
        case 1
          line xOrg(n)+6,yOrg(n),xOrg(n)+34,yOrg(n),2,pcolour(p) ' top line
        case 2
          line xOrg(n)+39,yOrg(n)+6,xOrg(n)+39,yOrg(n)+34,2,pcolour(p) ' right
        case 4
          line xOrg(n)+6,yOrg(n)+SIZEBX,xOrg(n)+34,yOrg(n)+SIZEBX,2,pcolour(p) ' bottom
        case 8
          line xOrg(n)-1,yOrg(n)+6,xOrg(n)-1,yOrg(n)+34,2,pcolour(p) ' left
      end select
      pause 100
    next i
    GUI CURSOR SHOW
  endif
end sub

' Label owner of given box number, increase owner's score
' Draw nothing if p(layer) is negative
sub LabelBox(n,p)
  if p >= 0 then
    score(p) = score(p) + 1
    text xOrg(n)+19, yOrg(n)+23, str$(p+1),"CM",5,1,pcolour(p),-1
    text xOrg(n)+20, yOrg(n)+23, str$(p+1),"CM",5,1,pcolour(p),-1
    text xOrg(n)+21, yOrg(n)+23, str$(p+1),"CM",5,1,pcolour(p),-1
    text 200+p*400, 25, str$(score(p)),"CM",5,1,pcolour(p),&h808080
  endif
end sub

' Update the mouse regularly
sub PeriodicInt
  local integer x = mouse(x,mouseport)
  local integer y = mouse(y,mouseport)

  if chooselevel then
    GUI CURSOR x, y   ' full screen for clicking buttons
  else
    x = x * (SIZEBX * SIZEX + 19) / MM.HRES
    y = y * (SIZEBX * SIZEY + 19) / MM.VRES
    GUI CURSOR x+xshift-10, y+yshift-10  ' confined to grid of dots

    local integer xs = x - x MOD 40
    local integer ys = y - y MOD 20

    if ys MOD 40 = 0 then xs = xs + 20
    if xs > SIZEBX * SIZEX then xs = xs - 40

    if mouseshow then
      sprite show 1,xs+xshift-10,ys+yshift-10,1
    else
      sprite show 1,MM.HRES-1,MM.VRES-1,1
    endif
  endif
end sub

' do something on mouse left-click
sub LeftClick
  local integer x = mouse(x,mouseport)
  local integer y = mouse(y,mouseport)

  ' 2 states: choose difficulty/level/quit button
  if chooselevel then
    if (x > 30) and (x < 110) then
      if (y > 525) and (y < 545) then ' easy box
        text  39,560,"X","CM",2,1,&hC0C0C0,-1  ' erase check mark hard
        text  39,535,"X","CM",2,1,&hFF6000,-1  ' show check mark easy
        skillevel = 0
      elseif (y > 550) and (y < 570) then ' hard box
        text  39,560,"X","CM",2,1,&hFF6060,-1  ' show check mark hard
        text  39,535,"X","CM",2,1,&hC0C0C0,-1  ' erase check mark easy
        skillevel = 1
      endif
    elseif (y > 510) and (y < 585) then   ' grid size button
      select case x
        case 150 to 250
          userselect = 1
          chooselevel = 0
        case 270 to 370
          userselect = 2
          chooselevel = 0
        case 390 to 490
          userselect = 3
          chooselevel = 0
        case 510 to 610
          userselect = 4
          chooselevel = 0
        case 630 to 730
          userselect = 0
          chooselevel = 0
      end select
    endif

  ' other state: select side of box
  else
    x = x * (SIZEBX * SIZEX + 19) / MM.HRES
    y = y * (SIZEBX * SIZEY + 19) / MM.VRES
    local integer xs = x - x MOD 40
    local integer ys = y - y MOD 20

    if ys MOD 40 = 0 then xs = xs + 20
    if xs > SIZEBX * SIZEX then xs = xs - 40

    xcell = int(xs / SIZEBX)
    ycell = int(ys / SIZEBX)
    cellnum = 1 + xcell + ycell * SIZEX
    cellside = 8
    if ys MOD 40 = 0 then cellside = 1
    if xcell = SIZEX then cellside = 2 : cellnum = cellnum - 1
    if ycell = SIZEY then cellside = 4 : cellnum = cellnum - SIZEX

    if (board(cellnum) and cellside) = 0 then ' chosen side is blank
      playbox = cellnum     ' return selected box and
      playside = cellside   '   selected side for main loop
    endif
  endif
end sub
