' Asteroid Clone for the Colour Maximite 2 Computer
' written by vegipete
' August-September, 2020
'
' Version History
' 0.10  testing, clean up edge cases, first release for testing
' 0.09  alien bullets kill now - suddenly got HARD!
' 0.08  change to MOD sample sounds, add many
' 0.07  aliens can shoot asteroids, player up
' 0.06  space ship can shoot aliens, points for aliens
' 0.05  aliens!
' 0.04  space ship can shoot rocks, pew-pew sound, points
' 0.03  moving space ship
' 0.02  moving rocks
' 0.01  testing concepts
'
' Required support files:
'   "RISsound.mod"        custom MOD file containing sounds
'   "Vector16x20.fnt"     custom FONT file for displaying numbers
'   "grayscaleRocks2.png" custom image with all the graphics
'   
' Notes:
' This program uses blitting to copy pixel regions. Throughout this program,
' these regions are refered to as 'sprites' although no actual sprite commands are
' used. Collision detection is done entirely analytically.

mode 1,8
cls

' asteroid info
' there are 12 different asteroid sprites. 1-4 are large, 5-8 are med and 9-12 are small
dim ast(100,4) 'num (1-12),x,y,dx,dy
' player info
dim ppos(4)    'angle (0-95),x,y,dx,dy
' collision distance vector
dim v(2)
dim asiz(12) = (0,32,32,32,32,20,20,20,20,12,12,12,12) ' asteroid radius for collision
' max velocity of asteroid based on size
dim avel(12) = (0,3,3,3,3,5,5,5,5,7,7,7,7) ' asteroid velocity - smaller asteroid is faster
' player shot info
dim bult(5,4) 'life left, xpos, ypos, xdir, ydir
' x-coord of dust animation sprite on sprite sheet - when asteroid/ufo is destroyed
dim dstx(19) = (0,10,23,39,58,80,105,133,164,198,235,275,318,364,413,465,520,578,639,703)
' size of dust animation sprite
dim dstsz(19) = (10,13,16,19,22,25,28,31,34,37,40,43,46,49,52,55,58,61,64,67)
' dust cloud info
dim dstcl(9,2) 'animation frame 0-19, xpos, ypos; (0,0) is next free slot
' smashed player ship chunk data - location, size and drift angle cos & sin
dim crx(5) = (260,265,260,265,281,272)
dim crw(5) = (  6,  6,  6,  6, 10, 10)
dim crh(5) = ( 15, 15, 15, 15,  7,  7)
dim crcos(5) = (1,-0.243,-0.882,0.672, 0.555,-0.942)
dim crsin(5) = (0,-0.970, 0.472,0.741,-0.832,-0.336)

' ufo data
dim ufo(4)   ' type, xpos, ypos, xvel, yvel
' ufo shot info
dim bufo(5,4) 'life left, xpos, ypos, xdir, ydir

newrun = 1  ' flag for newly started program, used to show intro
gameover = 1
level = 1
acount = level + 1 ' asteroid count
score = 0
pupscore = 10000  ' next milestone for another life
plive = 0
svol = 64   ' sound volume

' Sounds: sounds are stored in a custom MOD file.
' This MOD file contains only a single blank pattern, which the CMM2 will
' dutifully play as silence. However, the individual samples can be played
' on demand while the MOD file is silently playing.
play modfile "RISsound.mod"

hurn = 1    ' hurry up sound number 1 to start
hurs = 1000
settick hurs + 175,HurryUp

'end

' Vector Font 16 x 20
' ascii 32 to 128  - used for number display, ought to simplify the font
load font "Vector16x20.fnt"

' load sprite sheet
page write 3 : cls
load png "grayscaleRocks2.png"

' white page used for quit game effect
page write 4 : cls &hFFFFFF
quitime = 0

' Use page flipping to clean up display. Draw alternately on pages 1 and 2.
' While drawing on one, the other can be copied to page 0 for display
pflip = 1

do
  ' initialize some asteroids
  math set 0, ast()  ' zero the entire array
  for i = 0 to acount - 1
    ast(i,0) = 1 + int(rnd * 4)   ' large asteroid number

    j = rnd * 30
    ast(i,1) = MM.HRES/2 - 32 + 375 * cos(j)
    ast(i,2) = MM.VRES/2 - 32 + 275 * sin(j)
    ast(i,3) = avel(ast(i,0))/2 - rnd * avel(ast(i,0)) ' x velocity
    ast(i,3) = ast(i,3) + sgn(ast(i,3))/2
    ast(i,4) = avel(ast(i,0))/2 - rnd * avel(ast(i,0)) ' y velocity
    ast(i,4) = ast(i,4) + sgn(ast(i,4))/2
  next i

  ' prepare dust clouds
  math set -1, dstcl()
  dstcl(0,0) = 1

  wavend = 50
  fire = 0  ' delay until next player shot
  ufire = 0 ' delay until next ufo shot (minimum)
  
  'buct = 0    ' ufo bullet count
  'ufo(0) = 0  ' no ufo

  smash = gameover  ' for special case when game ends with destruction of last asteroid
  
  ' main game loop, with 2 categories of task:
  ' first, paint the entire screen according to current settings
  ' second, calculate all the new settings
  do
    t1 = timer    ' time @ start of loop

    ' erase everything on active drawing page to start fresh
    page write pflip
    cls

    ' paint active asteroids
    for i = 0 to 50 '100
      if ast(i,0) then

        an = ast(i,0) - 1
        select case an
          case 0 to 3
            ' draw big asteroids
            blit an*64,0, ast(i,1),ast(i,2), 64,64,3,4

          case 4 to 7
            ' draw medium asteroids
            blit 96+an*40,0, ast(i,1),ast(i,2), 40,40,3,4

          case 8 to 11
            ' draw small asteroids
            blit 224+an*24,0, ast(i,1),ast(i,2), 24,24,3,4
        end select
      endif
    next i

    ' paint ufos
    if ufo(0) = 2 then
      blit 512,0,ufo(1),ufo(2),48,24,3,4    ' large ufo
    elseif ufo(0) = 1 then
      blit 560,0,ufo(1),ufo(2),24,12,3,4    ' small ufo
    endif

    ' paint ufo bullets
    for i = 0 to 5
      if bufo(i,0) then  ' does bullet exist?
        blit 141,121,bufo(i,1),bufo(i,2),2,2,3  ' use a 2x2 white pixel box in a ship exhaust
      endif
    next i

    ' paint player bullets
    for i = 0 to 5
      if bult(i,0) then  ' does bullet exist?
        blit 141,121,bult(i,1),bult(i,2),2,2,3  ' use a 2x2 white pixel box in a ship exhaust
      endif
    next i

    ' paint player ship, drifting wreckage
    '   or GAME OVER message
    '   or introduction message
    if newrun then
      smash = 0
      blit 0,192,260,220,280,160,3,4  ' show intro screen
      kp$ = inkey$
      if kp$ = "1" then
        InitPlayer
        level = 0   ' outer do loop will increment this to 1 for start of game
        exit do
      elseif kp$ = chr$(27) then
        qrad = 500
        quitime = 1
      endif

    elseif gameover then
      blit 560,24,280,184,240,32,3,4    ' display "GAME OVER" sprite
      if timer > ngmt then blit 590,0,296,275,208,15,3,4  '  display "PRESS 1 TO PLAY AGAIN"
      if timer > ngmt + 20000 then newrun = 1   ' 20 seconds later switch back to opening screen
      kp$ = inkey$
      if kp$ = "1" then
        InitPlayer
        level = 0   ' outer do loop will increment this to 1 for start of game
        exit do
      elseif kp$ = chr$(27) then
        qrad = 500
        quitime = 1
      endif

    else
      if smash then
        if sprd < 30 then   ' finished smash wreckage
          sprd = sprd + .3
          for i = 0 to 5
            'an = i*10.75   ' easier access crcos(5)
            'blit crx(i),40,wrkx+sprd*cos(an),wrky-sprd*sin(an),crw(i),crh(i),3,4
            blit crx(i),40,wrkx+sprd*crcos(i),wrky-sprd*crsin(i),crw(i),crh(i),3,4
          next i
          cstold = 300
        else
          if plive > 1 then  ' more lives so prepare for next life
            ' wait until center is safe
            if CenterSafe() then
              plive = plive - 1
              smash = 0  ' end smash state
            endif
          else
            gameover = 1
            plive = 0
            ngmt = timer + 10000  ' show message in 10 seconds
            if acount = 0 then exit do  ' show next level behind "GAME OVER"
          endif
        endif
        
      else
        pp% = int(ppos(0))
        select case pp%
          case 0 to 24
            blit      pp%*32,burn,ppos(1),  ppos(2),  32,32,3,4
          case 25 to 48
            blit (48-pp%)*32,burn,ppos(1),  ppos(2)-1,32,32,3,6
          case 49 to 72
            blit (pp%-49)*32,burn,ppos(1)+1,ppos(2)-1,32,32,3,7
          case 73 to 95
            blit (96-pp%)*32,burn,ppos(1)+1,ppos(2),  32,32,3,5
        end select
      endif
    endif

    ' paint dispersing dust cloud
    for i = 1 to 9
      if dstcl(i,0) >= 0 then
        k = dstcl(i,0)
        blit dstx(k),128,dstcl(i,1)-dstsz(k)/2,dstcl(i,2)-dstsz(k)/2,dstsz(k),dstsz(k),3,4
        dstcl(i,0) = dstcl(i,0) + 1
        if dstcl(i,0) > 19 then dstcl(i,0) = -1
      endif
    next i

    ' paint score, wave and ships remaining
    tcol = &hF0F0C0   ' D8D8A8
    blit 300,220,80,2,77,19,3,4  '    text  80,2, "SCORE:", "LT",8,1,tcol,-1
    text 180,2, str$(score), "LT",8,1,tcol,-1
    blit 300,240,600,2,61,19,3,4 '    text 600,2, "WAVE:", "LT",8,1,tcol,-1
    text 680,2, str$(level), "LT",8,1,tcol,-1
    if plive > 1 then blit 300,40,350,2,min(176,16*(plive-1)),20,3,4

    ' iris display out, then end program
    if quitime then
      page write 4
      circle 400,300,qrad,6,1,0
      page and_pixels 4,pflip,pflip
      qrad = qrad - 5
      if qrad < 0 then end 
    endif
    
    ' display new image
    page copy pflip,0,D
    pflip = 3 - pflip '1 + (pflip=1)   ' toggle between page 1 and 2
    t2 = timer    ' time @ end of screen painting

    ' painting all done, now move stuff around
    
    ' check for asteroid hits, update asteroid positions
    for i = 0 to 100
      if ast(i,0) then
        an = ast(i,0)   ' easier access

        for j = 0 to 5
          ' test for player bullet hitting asteroid
          if bult(j,0) then ' does this bullet exist?
            v(1) = bult(j,1) - ast(i,1) - asiz(an)
            if v(1) > 1 + asiz(an) then continue for  ' early exit because gap is large
            v(2) = bult(j,2) - ast(i,2) - asiz(an)
            if math(magnitude v()) < 3 + asiz(an) then
              bult(j,0) = 0   ' end of bullet
              AstHit(i,1)
              continue for
            endif
          endif
          
          ' test for ufo bullet hitting asteroid
          if bufo(j,0) then ' does this bullet exist?
            v(1) = bufo(j,1) - ast(i,1) - asiz(an)
            if v(1) > 1 + asiz(an) then continue for  ' early exit because gap is large
            v(2) = bufo(j,2) - ast(i,2) - asiz(an)
            if math(magnitude v()) < 1 + asiz(an) then
              bufo(j,0) = 0   ' end of bullet
              buct = buct - 1
              AstHit(i,0)
              continue for
            endif
          endif
        next j

        if (smash = 0) and (newrun = 0) then
          ' test for asteroid hit player ship
          v(1) = ppos(1) + 16 - ast(i,1) - asiz(an)
          v(2) = ppos(2) + 16 - ast(i,2) - asiz(an)
          if math(magnitude v()) < 9 + asiz(an) then
            smash = 1
            sprd = 5    ' start the debris field
            play modsample 6,2,svol,8000    ' player explosion
            wrkx = ppos(1) + 16
            wrky = ppos(2) + 16
            ppos(1) = 390 : ppos(2) = 290 ' player position
            ppos(3) = 0 : ppos(4) = 0     ' player velocity
            AstHit(i,1)
            continue for
          endif
        endif

        ' test for asteroid hit ufo
        if ufo(0) = 2 then    ' large ufo
          v(1) = ufo(1) + 24 - ast(i,1) - asiz(an)
          v(2) = ufo(2) + 12 - ast(i,2) - asiz(an)
          if math(magnitude v()) < 17 + asiz(an) then
            ufo(0) = 0 : nufo = 120   ' ufo death by asteroid
            if ast(i,0) < 9 then NewDustCloud(ufo(1) + 24, ufo(2) + 12)
            AstHit(i,0)
            continue for
          endif
        elseif ufo(0) = 1 then  ' small ufo
          v(1) = ufo(1) + 12 - ast(i,1) - asiz(an)
          v(2) = ufo(2) +  6 - ast(i,2) - asiz(an)
          if math(magnitude v()) < 10 + asiz(an) then
            ufo(0) = 0 : nufo = 120    ' ufo death by asteroid
            if ast(i,0) < 9 then NewDustCloud(ufo(1) + 12, ufo(2) + 6)
            AstHit(i,0)
            continue for
          endif
        endif
        
        ' update and wrap asteroid x position
        ast(i,1) = ast(i,1) + ast(i,3)
        if ast(i,1) > 795 then
          ast(i,1) = ast(i,1) - 810
        elseif ast(i,1) < -15 then
          ast(i,1) = ast(i,1) + 810
        endif

        ' update and wrap asteroid y position
        ast(i,2) = ast(i,2) + ast(i,4)
        if ast(i,2) > 595 then
          ast(i,2) = ast(i,2) - 610
        elseif ast(i,2) < -15 then
          ast(i,2) = ast(i,2) + 610
        endif
      endif
    next i

    ' test for player bullet hitting ufo
    if ufo(0) then    ' is there a ufo?
      for i = 0 to 5    ' compare against all possible bullets
        if bult(i,0) then ' does this bullet exist?
          v(1) = bult(i,1) - ufo(1) - 12 * ufo(0)
          if v(1) > 24 then continue for  ' early exit because gap is large
          v(2) = bult(i,2) - ufo(2) -  6 * ufo(0)
          if math(magnitude v()) < 3 + 9 * ufo(0) then  ' hit!
            score = score + 200 + 800 * (ufo(0) = 1)
            NewDustCloud(ufo(1) + 12 * ufo(0), ufo(2) + 6 * ufo(0))
            bult(i,0) = 0   ' end of bullet
            ufo(0) = 0 : nufo = 120  ' end of ufo
            play modsample 4,3,svol,8000    ' kaboom sound
            exit for    ' don't need to check any more
          endif
        endif
      next i
    endif
    
    ' test for ufo bullet hitting player
    if (smash = 0) and (newrun = 0) then
      for i = 0 to 5    ' compare against all possible bullets
        if bufo(i,0) then ' does this bullet exist?
          v(1) = ppos(1) + 16 - bufo(i,1)
          v(2) = ppos(2) + 16 - bufo(i,2)
          if math(magnitude v()) < 12 then
            bufo(i,0) = 0   ' end of bullet
            buct = buct - 1
            smash = 1
            sprd = 5    ' start the debris field
            play modsample 6,2,svol,8000    ' player explosion
            wrkx = ppos(1) + 16
            wrky = ppos(2) + 16
            ppos(1) = 390 : ppos(2) = 290 ' player restart position @ center
            ppos(3) = 0 : ppos(4) = 0     ' player restart velocity = stopped
            exit for
          endif
        endif
      next i
    endif
    
    ' move and wrap player and ufo bullets
    for i = 0 to 5
      ' player bullets
      if bult(i,0) then
        bult(i,0) = bult(i,0) - 1  ' duration of bullet
        bult(i,1) = bult(i,1) + bult(i,3)
        if bult(i,1) > 799 then
          bult(i,1) = bult(i,1) - 800
        elseif bult(i,1) < 0 then
          bult(i,1) = bult(i,1) + 800
        endif
        bult(i,2) = bult(i,2) + bult(i,4)
        if bult(i,2) > 599 then
          bult(i,2) = bult(i,2) - 600
        elseif bult(i,2) < 0 then
          bult(i,2) = bult(i,2) + 600
        endif
      endif
      
      ' ufo bullets
      if bufo(i,0) then
        bufo(i,0) = bufo(i,0) - 1  ' duration of bullet
        if bufo(i,0) = 0 then ' has this bullet just expired?
          buct = buct - 1
        else
          bufo(i,1) = bufo(i,1) + bufo(i,3)
          if (bufo(i,1) > 799) then 
            bufo(i,1) = bufo(i,1) - 800
          elseif (bufo(i,1) < 0) then
            bufo(i,1) = bufo(i,1) + 800
          endif
          bufo(i,2) = bufo(i,2) + bufo(i,4)
          if bufo(i,2) > 599 then
            bufo(i,2) = bufo(i,2) - 600
          elseif bufo(i,2) < 0 then
            bufo(i,2) = bufo(i,2) + 600
          endif
        endif
      endif
    next i

    ' handle ufos
    if ufo(0) > 0 then  ' if it exists, move it
      ufo(1) = ufo(1) + ufo(3)
      if ufo(1) < -20 or ufo(1) > 799 then ufo(0) = 0 : nufo = 120 ' ufo departed
      ufo(2) = ufo(2) + ufo(4)
      if ufo(2) > 595 then    ' vertical ufo wrap
        ufo(2) = ufo(2) - 610
      elseif ufo(2) < -15 then
        ufo(2) = ufo(2) + 610
      endif
      if rnd > .96 then ufo(4) = 3 * (int(rnd * 3) - 1)  ' new random y-vel
      
      ' maybe create ufo bullet
      if buct < 5 then  ' is there room for another ufo bullet?
        if ufire = 0 then
          if rnd > .75 then
            ufire = 15   ' ufo can't fire again for a while
            for i = 0 to 5
              if bufo(i,0) = 0 then   ' look for empty slot
                if (ufo(0) = 2) or (newrun = 1) or (score = 0) then
                  ' choose a random direction if large ufo or no player
                  angle = rnd * 6.283
                else
                  ' aim towards player, better aim with increasing score
                  angle = atan2(ppos(2) - ufo(2), ppos(1) - ufo(1))
                  angle = angle + (.5 - rnd) * 3000 / score
                endif
                cangle = cos(angle)
                sangle = sin(angle)

                bufo(i,0) = 24  ' ufo bullet duration
                bufo(i,1) = ufo(1) + 12 * ufo(0) * (1 + cangle) ' start bullet near
                bufo(i,2) = ufo(2) +  6 * ufo(0) * (1 + sangle) '  edge of ufo
                bufo(i,3) = 12 * cangle
                bufo(i,4) = 12 * sangle
                buct = buct + 1   ' increase ufo bullet count
                exit for  ' stop looking
              endif
            next i
          endif
        endif
      endif
      
    elseif (acount > 0) and (smash = 0) then ' maybe create new one if there are still asteroids
      if nufo = 0 then    ' enough time passed for new ufo?
        if rnd > .99 then
          if score > 10000 then
            ufo(0) = 1    ' always small ufos
          else
            ufo(0) = 1 + (rnd > (score / 10000))  ' select ufo size: 1 = small, 2 = large
          endif
          ufo(1) = (rnd > .5)            ' select left = 0 or right = 1
          ufo(3) = 3 - 6 * ufo(1)        ' x-vel = -3 or +3 to start
          ufo(1) = 810 * ufo(1) - 15     ' start ufo at -15 on left or 795 on right
          ufo(2) = 100 + int(400 * rnd)    ' random vertical start height
          ufo(4) = 3 * (int(rnd * 3) - 1)  ' y-vel = -3, 0 or +3 to start
          if newrun = 0 then
            play modsample 10,4,svol,8000    ' ufo alert klaxon
          endif
        endif
      endif
    endif
    
    ' ignore user input and ship motion if smashed
    if (smash = 0) and (newrun = 0) then
      ' read user input (left,right,thrust,fire,hyperjump)
      direction = 0
      burn = 64
      if keydown(0) then
        for i = 1 to keydown(0)
          if keydown(i) = 130 then direction = -1.7 ' left        left arrow
          if keydown(i) = 131 then direction =  1.7 ' right      right arrow
          if keydown(i) = 128 then burn = 96        ' engine on    up  arrow
          'if keydown(i) =  70 and fire = 0 then fire = 1 ' fire         'F'
          if keydown(i) = 102 and fire = 0 then fire = 1 ' fire         'f'
          'if keydown(i) =  72 then hype = 1         ' hyper jump   'H'
          'if keydown(i) = 104 then hype = 1         ' hyper jump   'h'
          if keydown(i) =  27 then qrad = 500 : quitime = 1 ' Esc to quit
        next i
      endif
      
      ' force one shot per ctrl press - no auto-repeat
      if (keydown(7) and 34) then  ' Ctrl keys to fire
        if efire = 0 then
          efire = 1       ' mark rising edge
          nfire = 1
        endif
      else
        efire = 0
      endif
      if fire = 0 and nfire = 1 then fire = 1 : nfire = 0

      ' adjust rotation
      ppos(0) = ppos(0) + direction
      if ppos(0) > 95 then ppos(0) = ppos(0) - 95
      if ppos(0) <  0 then ppos(0) = ppos(0) + 95

      angle = ppos(0) * PI / 48
      cangle = cos(angle)
      sangle = sin(angle)

      ' create bullet if there are still asteroids and/or ufo on screen
      if (fire = 1) and (acount + ufo(0) > 0) then
        for i = 0 to 5    ' find space in list for new bullet
          if bult(i,0) = 0 then
            bult(i,0) = 30    ' bullet duration
            bult(i,1) = ppos(1) + 16 + 17 * sangle
            bult(i,2) = ppos(2) + 16 - 17 * cangle
            bult(i,3) = ppos(3) + sangle * 12
            bult(i,4) = ppos(4) - cangle * 12
            fire = -6  ' can't fire again for a while
            exit for
          endif
        next i
        play modsample 3,2,svol,8000   ' fire bullet sound
        bsdel = 8   ' prevent engine sound for a while
      endif

      ' thrust
      if burn = 96 then
        if bsdel = 0 then   ' don't replay sound for a while
          play modsample 5,2,svol,8000    ' engine thrust sound
          bsdel = 7
        endif
        ppos(3) = ppos(3) + sangle / 2.1
        ppos(4) = ppos(4) - cangle / 2.1
      endif

      ' velocity decays away slowly
      ppos(3) = ppos(3) * .995
      ppos(4) = ppos(4) * .995

      ' adjust position
      ppos(1) = ppos(1) + ppos(3)
      if ppos(1) > 800 then
        ppos(1) = ppos(1) - 815
      elseif ppos(1) < -15 then
        ppos(1) = ppos(1) + 815
      endif

      ppos(2) = ppos(2) + ppos(4)
      if ppos(2) > 600 then
        ppos(2) = ppos(2) - 615
      elseif ppos(2) < -15 then
        ppos(2) = ppos(2) + 615
      endif
    endif

    'periodic event timers - note version without 'IF' is slightly faster
    'if fire < 0 then fire = fire + 1   ' player shot reload timer
    fire = fire + (fire < 0)          ' player shot reload timer
    ufire = ufire - (ufire > 0)       ' ufo shot reload timer
    bsdel = bsdel - (bsdel > 0)       ' burn sound timer
    nufo = nufo - (nufo > 0)          ' min delay before new ufo
    
    if score > pupscore then
      pupscore = pupscore + 10000  ' next milestone for another life
      play modsample 9,4,svol,8000    ' 
      plive = plive + 1
    endif

    page write 0 : print @(0,550) timer - t1 ', timer - t2
    do : loop until timer - t1 > 35    ' minimum time until next frame redraw

    ' wave ends when all asteroids gone, no ufo and player not smashed
    wavend = wavend - (acount = 0) * (smash = 0) * (ufo(0) = 0)

  loop until wavend = 0
  nfire = 0
  level = level + 1
  acount = level + 1
  if acount > 11 then acount = 11
  hurs = 1000   ' reset hurry-up tone speed
  settick hurs + 175, HurryUp
  nufo = 150    ' no ufo for at least 5 seconds
loop

' asteroid number n has been struck
' adjust score only if hit by player (scr = 1)
' crack large ones in half
' small ones turn to dust and vanish
sub AstHit(n,scr)
  play modsample 4,3,svol,8000    ' kaboom sound
  select case asiz(an)
    case 12  ' small asteroids are doomed
      acount = acount - 1   ' small asteroid gone, one less
      score = score + 100 * scr
      NewDustCloud(ast(n,1) + 12, ast(n,2) + 12)
      if n < acount then   ' last one in the list?
        ast(n,0) = ast(acount,0) ' no so move last one to here
        ast(n,1) = ast(acount,1)
        ast(n,2) = ast(acount,2)
        ast(n,3) = ast(acount,3)
        ast(n,4) = ast(acount,4)
      endif
      ast(acount,0) = 0  ' asteroid at end of list destroyed
    case else  ' larger asteroids split into 2 smaller ones
      afam = (an-1) AND 4   ' =0 for large, =4 for medium
      score = score + (20 + 30 * (afam=4)) * scr
      ast(n,0) = afam + 5 + int(rnd * 4) ' shrink asteroid 1 size
      ast(n,1) = ast(n,1) + 4 ' re-center asteroid
      ast(n,2) = ast(n,2) + 4 ' re-center asteroid

      ast(acount,0) = afam + 5 + int(rnd * 4) ' create new one
      ast(acount,1) = ast(n,1)
      ast(acount,2) = ast(n,2)

      ' new velocity for old piece
      ast(n,3) = avel(ast(n,0))/2 - rnd * avel(ast(n,0)) ' x velocity
      ast(n,3) = ast(n,3) + sgn(ast(n,3))/2
      ast(n,4) = avel(ast(n,0))/2 - rnd * avel(ast(n,0)) ' y velocity
      ast(n,4) = ast(n,4) + sgn(ast(n,4))/2

      ' new velocity for new piece
      ast(acount,3) = avel(ast(n,0))/2 - rnd * avel(ast(n,0)) ' x velocity
      ast(acount,3) = ast(acount,3) + sgn(ast(acount,3))/2
      ast(acount,4) = avel(ast(n,0))/2 - rnd * avel(ast(n,0)) ' y velocity
      ast(acount,4) = ast(acount,4) + sgn(ast(acount,4))/2

      acount = acount + 1  ' next empty slot
  end select
end sub

' Generate a new dust cloud at the given coordinates
sub NewDustCloud(x,y)
  k = dstcl(0,0)
  dstcl(k,0) = 0
  dstcl(k,1) = x
  dstcl(k,2) = y
  k = k * (k<9) + 1
  dstcl(0,0) = k
end sub

' Test if the center of the screen is safe for a new ship to materialize
' That means no ufos and no ufo bullets on-screen and no asteroids near the center
function CenterSafe()
  CenterSafe = 0
  if ufo(0) > 0 then exit function  ' ufo on screen so not safe
  if buct > 0 then exit function    ' ufo bullets on screen so not safe
  if acount = 0 then
    CenterSafe = 1 : exit function  ' clear skies so it is very safe
  else
    cstmin = 400
    for ii = 0 to 50    ' test for asteroids near screen center
      if ast(ii,0) then
        v(1) = 390 - ast(ii,1)
        v(2) = 285 - ast(ii,2)
        cst = math(magnitude v())
        if cst < 125 then exit function   ' asteroid too close - not safe
        if cstmin > cst then cstmin = cst ' find closest asteroid
      endif
    next ii
  endif
  if cstmin > 200 then CenterSafe = 1 : exit function
  if cstmin > cstold then   ' gap is increasing
    CenterSafe = 1
  else
    cstold = cstmin
  endif
end function

' Initialize player location - near screen center
sub InitPlayer
  ppos(0) = 0                    ' player angle 0 to 95
  ppos(1) = 390 : ppos(2) = 285 ' player position
  ppos(3) = 0 : ppos(4) = 0     ' player velocity

  direction = 0   ' start facing up
  burn = 64       ' engines off - also y-coord of sprites on page 3
  level = 1
  acount = level + 1 ' asteroid count
  score = 0
  plive = 3
  newrun = 0
  gameover = 0
  pupscore = 10000  ' next milestone for another life
  nufo = 300    ' no ufo for at least 10 seconds
  
  for i = 0 to 5
    bufo(i,0) = 0   ' remove any ufo shots
  next i
  buct = 0    ' ufo bullet count
  ufo(0) = 0  ' no ufo
  
end sub

' Play the 'hurry up' background tones.
' alternate between 2 tones, and slowly increase tempo
sub HurryUp
  if gameover then
    hurs = 1000
  else
    play modsample hurn,1,svol,8000
    hurn = 3 - hurn   ' toggle between 1 and 2
    if hurs > 0 then hurs = hurs * .98
  endif
  settick hurs + 175, HurryUp
end sub
