' COBO2 for the Colour Maximite 2
' by vegipete, Sept 2020
' 
' Clear a playing field of all balls except one by
' knocking balls together.
' Loosely based on the mobile device game Fling!
'
' support file: "cobographics.png" which must be in the
'               same directory as the this program.
'
' versions:
'   COBO  - for the original Colour Maximite, April 2013
'   COBO2 - rewrite/port for the Colour Maximite 2
'     v2.3  - first release

mode 1,16,0
cls

XSIZE = 12 : YSIZE = 10   ' field size in cells
XL = 100 : YT = 50         ' top left corner of field
SZ = 50                   ' size of balls/cells
MAXBALLS = 10
dim float level_data(100,MAXBALLS)
dim curlevel(MAXBALLS,MAXBALLS)   ' undo stack for current level

dim wnote(5) = (131,165,196,262,294,262)  ' C3 E3 G3 C4 D4 C4
dim wdur(5)  = (100,100,100,250,100,250)

' test for nunchuk - unused in v2.3
gotnun = 1
on error skip
wii nunchuk open 3
if MM.ERRNO = 16 then gotnun = 0

' load and prepare graphics
page write 2
load png "cobographics.png"
page write 0

for i = 0 to 9
  sprite read i+1,i*SZ,250,SZ,SZ,2      ' 10 coloured balls
  sprite show i+1,MM.HRES-1,MM.VRES-1,1 ' position them off screen
next i

sprite read 11,500,250,SZ,SZ,2  ' cursor
sprite show 11,MM.HRES-1,MM.VRES-1,2

TitleScreen

' generate playing field
' almost white top
box XL,YT,600,500,1,&hFFFFFF,&hEEEEEE

' white grid lines
for i = 1 to 11
  line XL+i*SZ,YT,XL+i*SZ,550
next i
for i = 1 to 9
  line XL,YT+i*SZ,700,YT+i*SZ
next i

' right wall
blit 100,50,700,50,50,100,2
for i = 0 to 7
  blit 100,100,700,150+i*50,50,100,2
next i

' bottom wall
blit 0,150,100,550,100,50,2
for i = 0 to 10
  blit 50,150,150+i*50,550,100,50,2
next i

' turn entire playing field into a sprite
sprite read 12,XL,YT,650,550

ReadLevelData

level = 1

do  ' game loop
  cursor = 0
  LoadLevel(level)
  stepnum = 0
  do  ' level loop
    key$ = inkey$
    if key$ <> "" then
      select case asc(key$)
        case 48 to 57 ' digit 0 to 9
          bn = asc(key$) - 47
          if curlevel(stepnum,bn) <> 0 then
            SelectBall(stepnum,bn)
            cursor = bn
          endif
        case 128      ' up
          FlickBall(cursor,0)
        case 129      ' down
          FlickBall(cursor,1)
        case 130      ' left
          FlickBall(cursor,2)
        case 131      ' right
          FlickBall(cursor,3)
        case 14       ' space
          level = level + 1
          if level > level_data(0,0) then level = 1
          LoadLevel(level)
          stepnum = 0
        case 76, 108  ' enter a level code? "L" / "l"
          lev_req = GetLevel()
          if lev_req then
            level = lev_req
            exit do
          else
            DrawLevel(stepnum) ' no code so redraw current level
          endif
        case 82, 114  ' restart level? "R" / "r"
          HideAll
          stepnum = 0
          DrawLevel(stepnum)
        case 90, 122  ' undo a move? "Z" / "z"
          if stepnum > 0 then
            HideAll
            stepnum = stepnum - 1   ' undo one step
            DrawLevel(stepnum)
          endIf
        case 27       ' ESC
          mode 1,8
          cls
          text 0,10,"Good Bye. The balls will be waiting...","LT",3
          ? @(0,100)
          end
      end select
    endif

    'count remaining balls - level finished if only one left
    cnt = 0
    for i = 1 To MAXBALLS
      if curlevel(stepnum,i) then cnt = cnt + 1
    next
    if cnt = 1 Then
      do while Inkey$ <> "": loop  ' clear any key presses
      i = LevelCode(level)
      rbox 250,250,300,100,20,&h808080,&h808080
      rbox 260,260,280, 80,10,&hC0C0C0,&hC0C0C0
      text 400,270,"Level "+str$(level)+" Solved!","CT",10,,&hFF8822,-1
      text 400,305,"Code: "+str$(int(i)),"CT",10,,&hFF8822,-1
      'Print @(xl+20,yt+88) "Press SPACE to continue..."

      pause 250
      for i = 0 to 5
        play tone 2 * wnote(i), 2 * wnote(i), wdur(i)
        pause wdur(i) + 50
      next i

      do : loop until Inkey$ <> ""
      sprite write 12,XL,YT  ' redraw the field, covering the level solved message and last ball
      HideAll   ' move remaining sprite offscreen, no image damage
      exit do   ' this level is done!
    EndIf

  loop
  level = level + 1
  if LevelCode(level) = 0 then exit do
loop

cls
cinc% = &h010604
col% = 0
for i = 1 to 32
  col% = col% + cinc%
  text MM.HRES/2,240,"Congratulations!","CT",10,1,col%
  text MM.HRES/2,270,"You are so good that","CT",10,1,col%
  text MM.HRES/2,300,"you have completed","CT",10,1,col%
  text MM.HRES/2,330,"all the levels!","CT",10,1,col%
  pause 20
next i

pause 5000

for i = 1 to 32
  col% = col% - cinc%
  text MM.HRES/2,240,"Congratulations!","CT",10,1,col%
  text MM.HRES/2,270,"You are so good that","CT",10,1,col%
  text MM.HRES/2,300,"you have completed","CT",10,1,col%
  text MM.HRES/2,330,"all the levels!","CT",10,1,col%
  pause 20
next i

end

' launch the requested ball in the requested direction
Sub FlickBall(bnum,dir)
  Local x,y,dx,dy

  if cursor then
    sprite show 11,MM.HRES-1,MM.VRES-1,2    ' hide the cursor

    'set a new undo level
    for i = 1 To MAXBALLS
      curlevel(stepnum+1,i) = curlevel(stepnum,i)
    next i
    stepnum = stepnum + 1

    x = int(curlevel(stepnum,bnum))
    y = int(100*curlevel(stepnum,bnum) mod 100)

    dx = 0 : dy = 0
    if dir = 0 then dy = -1
    if dir = 1 then dy =  1
    if dir = 2 then dx = -1
    if dir = 3 then dx =  1

    if NotEmpty(x+dx,y+dy) then ' ball in the way
      Wobble(bnum,x,y)
      stepnum = stepnum - 1      'invalid move so ignore new undo level
      SelectBall(stepnum,bnum)   'reselect the ball that didn't move
    else
      MoveBall(bnum,dir)
      cursor = 0
    endif
  endif
end Sub

sub DrawLevel(depth)
  sprite show 11,MM.HRES-1,MM.VRES-1,2    ' hide the cursor
  for DLi = 1 to 10
    sprite show DLi,MM.HRES-1,MM.VRES-1,1 ' move all balls out of the way
  next DLi
  for DLi = 1 to 10
'    n = level_data(lev,DLi)
    n = curlevel(depth,DLi)
    if n <> 0 then
      x1 = int(n)
      y1 = Int(100*n mod 100)
      'y1 = int((n - x1) * 102)
      sprite show DLi,XL+x1*SZ,YT+y1*SZ,1  ' visible so move it into place
      c = c + 1
    endif
  next DLi
end sub

sub LoadLevel(n)
  for LLi = 1 to MAXBALLS
    curlevel(0,LLi) = level_data(level,LLi) ' copy this level to working undo stack
  next LLi
  DrawLevel(0)
  text 50,20,"Level "+str$(level)+"  ","LT",10,,&hFF8822
end sub

' put cursor on requested ball
sub SelectBall(st,bn)
  n = curlevel(st,bn)
  if n then
    x1 = int(n)
    y1 = Int(100*n mod 100)
    'y1 = int((n - x1) * 102)
    sprite show 11,XL+x1*SZ,YT+y1*SZ,2  ' put cursor on ball
  endif
end sub

' put ball n at x,y
sub ShowBall(n,x,y)
  if x < 0 or x > 11 or y < 0 or y > 9 then
    sprite show n,MM.HRES-1,MM.VRES-1,2    ' put ball off screen (hide it)
  else
    sprite show n,XL+x*SZ,YT+y*SZ,2
  endif
return

' move the cursor somewhere
sub ShowCursor(x,y)
  if x < 0 or x > 11 or y < 0 or y > 9 then
    sprite show 11,MM.HRES-1,MM.VRES-1,2    ' hide the cursor
  else
    sprite show 11,XL+x*SZ,YT+y*SZ,2
  endif
return

' hide cursor and all balls off secreen
sub HideAll
  sprite show 11,MM.HRES-1,MM.VRES-1,2    ' hide the cursor
  cursor = 0
  for HAi = 1 to MAXBALLS
    sprite show HAi,MM.HRES-1,MM.VRES-1,1 ' move all balls out of the way
  next HAi
end sub

'''''''''''''''''''''''''''''''''''''''''''''''
'flick the given ball in the indicated direction
'update appropriately for valid move
Sub MoveBall(bnum,dir)
  Local x,y,dx,dy,sx,sy,mx,my
  Local i,clsn

  mx = int(curlevel(stepnum,bnum))
  my = int(100*curlevel(stepnum,bnum) mod 100)  'cell coords
  dx = 0 : dy = 0
  if dir = 0 then dy = -1   ' up
  if dir = 1 then dy =  1   ' down
  if dir = 2 then dx = -1   ' left
  if dir = 3 then dx =  1   ' right
  i = 0 : clsn = 0
  sx = XL+SZ*mx : sy = YT+SZ*my   'starting x,y coords
  x = sx : y = sy                  'moving x,y coords
  do
    t = timer
    x = x + 5 * dx : y = y + 5 * dy

    ' wait for scanline to be somewhere safe before drawing
    do : loop until (getscanline < y) or (getscanline > y + 75) '550
    sprite show bnum,x,y,1          'at least one cell is empty

    i = i + 5
    if i = SZ then                'into next cell after SZ steps
      mx = mx + dx : my = my + dy
      i = NotEmpty(mx+dx,my+dy)   'test next cell in direction of travel
      if i = -1 then              'ball went off edge of field
        if clsn then              'test if a collision has happened
          ' move off screen - arc?
          sprite show bnum,MM.HRES-1,MM.VRES-1,1 'ball knocked off field - it's gone
          curlevel(stepnum,bnum) = 0 'mark ball as gone
          Exit Sub
        else
          Wobble(bnum,mx,my)      'no colision so illegal move
          sprite show bnum,sx,sy,1  'move ball back to start
          stepnum = stepnum - 1   'invalid move so ignore new undo level
          exit Sub
        endIf
      elseif i then               'ball hit another ball
        play tone 1600,1600,20
        clsn = 1
        curlevel(stepnum,bnum) = mx + my/100 'move ball to new spot
        bnum = i                  'now start moving ball that we hit
        mx = mx + dx : my = my + dy
        sx = XL+SZ*mx : sy = YT+SZ*my   'new ball's starting x,y coords
        x = sx : y = sy                 'new ball's moving x,y coords
        i = NotEmpty(mx+dx,my+dy)   'test next cell in direction of travel
        do while i > 0              'is there another ball in the way?
          pause 5
          play stop
          pause 5
          play tone 1600,1600,20
          bnum = i                  'shift to next ball
          mx = mx + dx : my = my + dy
          sx = XL+SZ*mx : sy = YT+SZ*my   'new ball's starting x,y coords
          x = sx : y = sy                 'new ball's moving x,y coords

          i = NotEmpty(mx+dx,my+dy) 'test next cell in direction of travel
        loop
      endif
      i = 0
    endif
    do : loop until timer - t > 5
  loop
End Sub

'''''''''''''''''''''''''''''''''''''''''''''''
'Test contents of (x,y)
'Return 0 if empty
'Return -1 if off field
'Return number of ball [1 to MAXBALLS] if position has a ball
function NotEmpty(x,y)
  Local n

  if x<0 or x>XSIZE-1 or y<0 or y>YSIZE-1 then NotEmpty = -1 : exit function
  for n = 1 To MAXBALLS
    If curlevel(stepnum,n) = x + y/100 then
      NotEmpty = n : exit function   'there's a ball in this spot
    EndIf
  next n 'MUST SPECIFY VARIABLE HERE. WHY? BUG?
  NotEmpty = 0
end function

'''''''''''''''''''''''''''''''''''''''''''''''
'Wobble the specified sprite number back and forth at the given cell x,y
sub Wobble(num,x,y)
  Local i

  for i = 1 To 5
    sprite show num,XL+x*SZ+2,YT+y*SZ,1
    play tone 220,220,10
    pause 10
    sprite show num,XL+x*SZ+4,YT+y*SZ,1
    play tone 180,180,10
    pause 10
    sprite show num,XL+x*SZ+2,YT+y*SZ,1
    play tone 220,220,10
    pause 10
    sprite show num,XL+x*SZ+0,YT+y*SZ,1
    play tone 280,280,10
    pause 10
    sprite show num,XL+x*SZ-2,YT+y*SZ,1
    play tone 220,220,10
    pause 10
    sprite show num,XL+x*SZ-4,YT+y*SZ,1
    play tone 180,180,10
    pause 10
    sprite show num,XL+x*SZ-2,YT+y*SZ,1
    play tone 220,220,10
    pause 10
    sprite show num,XL+x*SZ-0,YT+y*SZ,1
    play tone 280,280,10
    pause 10
  next
end sub

'''''''''''''''''''''''''''''''''''''''''''''''
Sub TitleScreen
  sprite show 4,134,260,1
  sprite show 3,263,260,1
  sprite show 2,422,260,1
  sprite show 5,520,260,1

  pause 1500    ' wait for video mode to sync

  for i = 7 to 255 step 8
'    text 180,200,"There","CM",3,1,rgb(i,i,i)
    text 181,200,"There","CM",10,1,rgb(i,i,i),-1
    text 400,240,"3580487902604861","CM",9,1,RGB(i,i,i),-1
    pause 50
  next i
  pause 750
  for i = 248 to 0 step -8
'    text 180,200,"There","CM",3,1,rgb(i,i,i)
    text 181,200,"There","CM",10,1,rgb(i,i,i),-1
    text 400,240,"0580087900600861","CM",9,1,RGB(i,i,i),-1
    pause 50
  next i

  for i = 264 to 372 step 2
    sprite show 3,i,260,1   ' shift 2 to 1
    do : loop until getscanline > 500 'pause 1
  next i
  play tone 1600,1600,20
  for i = 422 to 470 step 2
    sprite show 2,i,260,1   ' shift 1 to 4
    do : loop until getscanline > 500 'pause 1
  next i
  play tone 1600,1600,20
  for i = 521 to 799 step 2
    sprite show 5,i,260,1   ' send 4 off right
    do : loop until getscanline > 500
  next i

  for i = 372 to 184 step -2
    sprite show 3,i,260,1   ' shift 2 to 3
    do : loop until getscanline > 500 'pause 1
  next i
  play tone 1600,1600,20
  for i = 133 to -49 step -2
    sprite show 4,i,260,1   ' send 3 off left
    do : loop until getscanline > 500 'pause 1
  next i

  for i = 184 to 420 step 2
    sprite show 3,i,260,1   ' shift 2 to 1
    do : loop until getscanline > 500 'pause 1
  next i
  play tone 1600,1600,20
  for i = 471 to 799 step 2
    sprite show 2,i,260,1   ' send 1 off right
    do : loop until getscanline > 500 'pause 1
  next i

  cinc% = &h010604
  col% = 0
  for i = 1 to 32
    col% = col% + cinc%
    ShowInstructions(col%)
    pause 20
  next i

  do : loop until inkey$ <> ""

  for i = 1 to 32
    col% = col% - cinc%
    ShowInstructions(col%)
    pause 20
  next i

  HideAll
  cls
End Sub

'''''''''''''''''''''''''''''''''''''''''''''''
sub ShowInstructions(c%)
  text 10,340,"Finish each level by knocking all but one ball","LT",10,1,c%
  text 10,370,"from the field. However, balls cannot be tossed","LT",10,1,c%
  text 10,400,"directly off the edge and at least one empty","LT",10,1,c%
  text 10,430,"spot is required in the direction of travel.","LT",10,1,c%
  text 10,490,"Press [Z] to undo one step, [R] to reset level.","LT",10,1,c%
  text 10,520,"Press [L] to enter level code, [ESC] to quit.","LT",10,1,c%
end sub

'''''''''''''''''''''''''''''''''''''''''''''''
' read all levels from data statements
sub ReadLevelData
  local j
  local n

  restore
  n = 0
  math set 0, level_data()
  do
    n = n + 1
    read level_data(n,0)
    if level_data(n,0) = 999 then
      for j = 1 to 10
        read level_data(n,j)
      next j
    else
      level_data(0,0) = n - 1
      exit do
    endif
  loop
end sub

'''''''''''''''''''''''''''''''''''''''''''''''
function GetLevel()
  local i
  local usercode%

  HideAll
  rbox 250,250,300,100,20,&h808080,&h808080
  rbox 260,260,280, 80,10,&hC0C0C0,&hC0C0C0
  text 399,270,"Enter Level Code:","CT",10,,&hFF8822,-1

  code$ = ""
  do
    text MM.HRES/2,MM.VRES/2," "+code$+" ","CT",10,,&hFF8822,&hC0C0C0
    do
      kp$ = inkey$
    loop until kp$ <> ""  ' loop until key press detected
    select case kp$
      case "0" to "9" ' digit ao add to string if it fits
        if len(code$) < 8 then code$ = code$ + kp$
      case chr$(8), chr$(127), chr$(130) ' backspace or delete or whatever
        if len(code$) then code$ = left$(code$,len(code$)-1)
      case chr$(27)   ' <ESC> so quit with no valid code
        GetLevel = 0
        sprite write 12,XL,YT  ' redraw the field
        exit function
      case chr$(13)   ' <CR> so test the code
        exit do
    end select
  loop
  usercode% = val(code$)

  for i = 1 to level_data(0,0)
    if usercode% = LevelCode(i) then
      GetLevel = i
      sprite write 12,XL,YT  ' redraw the field
      exit function
    endif
  next i

  sprite write 12,XL,YT  ' redraw the field
  GetLevel = 0
end function

'''''''''''''''''''''''''''''''''''''''''''''''
' return level code or 0 if invalid level
Function LevelCode(level) as integer
  Local i
  Local c$
  Local work$

  work$ = ""
  if level_data(level,0) = 999 then
    ' build a string containing all digits of current level position data
    for i = 1 to 10
      if level_data(level,i) then
        work$ = work$ + str$(level_data(level,i))
      endif
    next i
    work$ = work$ + "1234567891"  ' pad string to minimum length

    ' remove all characters other than 1-9 from front of string
    do while left$(work$,1) < "1" or left$(work$,1) > "9"
      work$ = right$(work$,len(work$) - 1)
    loop

    ' strip all characters other than 1-9 from middle of string
    i = 2
    do
      c$ = mid$(work$,i,1)
      if c$ < "1" or c$ > "9" then
        work$ = left$(work$,i-1) + right$(work$,len(work$) - i)
        i = i - 1
      endif
      i = i + 1
    loop until i = 10
    work$ = Left$(work$,8)
    LevelCode = val(work$)
  else
    LevelCode = 0
  endif
End Function




' Level data
' 1 element for each of max 10 balls per level
' integer part = x, fractional part = y, can't place ball at (0,0)
data 999, 2.05,10.05,    0,    0,    0,    0,    0,    0,    0,    0  ' 01
data 999, 6.01,    0, 2.06, 6.07,    0,    0,    0,    0,    0,    0  ' 02
data 999,    0,    0,    0, 2.05, 3.05, 9.05,    0,    0,    0,    0  ' 03
data 999, 2.06, 4.05,    0,    0,    0,    0, 4.08,    0,    0,    0  ' 04
data 999, 2.02,    0,    0, 9.02,    0, 3.09,    0,    0,    0,    0  ' 05
data 999, 3.01,    0, 8.01,    0,    0,    0,    0,    0,    0, 4.08  ' 06
data 999,    0, 1.06,    0,10.06,    0, 2.09,    0,    0,    0,    0  ' 07
data 999,    0,    0,    0,    0, 9.01, 9.07, 3.02,    0,    0,    0  ' 08
data 999, 2.02,    0, 2.03, 2.08,    0, 5.06,    0,    0,    0,    0  ' 09
data 999, 4.02, 4.04, 4.05,    0, 8.04,    0,    0,    0,    0,    0  ' 10
data 999,    0, 2.05, 5.05, 6.06, 3.07,    0,    0,    0,    0,    0  ' 11
data 999,    0,    0,    0, 8.04, 8.06, 7.06,10.06,    0,    0,    0  ' 12
data 999, 5.04,    0,    0, 5.07, 6.02,    0,    0,    0,    0, 9.06  ' 13
data 999, 3.03,    0, 3.07,    0,    0, 4.06, 7.04,    0,    0,    0  ' 14
data 999,10.09,10.02,    0,    0, 9.01, 5.03,    0,    0,    0,    0  ' 15
data 999, 8.02, 8.05, 7.06, 5.04,    0,    0,    0,    0,    0,    0  ' 16
data 999,    0, 8.02, 9.05, 5.04,    0,    0,    0,    0, 5.08,    0  ' 17
data 999,11.04,11.06,11.08,    0,    0,    0, 2.07,    0,    0,    0  ' 18
data 999,    0,    0, 1.06, 2.09, 4.06, 5.08,    0,    0, 4.08,    0  ' 19
data 999, 0.05, 2.05, 3.05, 4.05, 5.05, 6.05, 7.05, 8.05,10.05,11.05  ' 20
data 999, 2.07,    0, 4.07,    0, 6.07,    0, 5.04,    0,    0,    0  ' 21
data 999,    0,    0,    0, 6.01, 6.07, 4.07, 7.08, 8.06,    0,    0  ' 22
data 999, 3.04,    0,    0,    0, 7.05, 3.07, 6.07,    0, 6.08,    0  ' 23
data 999, 6.03,    0,    0, 6.04,    0, 8.03, 9.06,    0,    0, 6.08  ' 24
data 999, 2.04, 3.07, 5.06,    0,    0,    0,    0, 3.06, 8.04,    0  ' 25
data 999,    0,11.02,    0,    0,    0,11.06, 9.05, 6.06,10.09,    0  ' 26
data 999, 4.02, 5.05, 3.09, 6.09, 9.08,    0,    0,    0,    0,    0  ' 27
data 999, 6.03,    0,    0,    0, 6.05, 6.07, 8.04, 9.04,    0,    0  ' 28
data 999,    0, 2.02,    0, 4.02,    0, 6.03,    0, 3.08, 5.08,    0  ' 29
data 999, 3.03,    0, 5.03,    0, 7.02,    0, 8.07,    0, 3.08,    0  ' 30
data 999,    0, 3.05, 4.06,    0,    0,    0, 5.09, 4.03, 8.05,    0  ' 31
data 999, 7.01, 7.02, 7.05, 5.05, 6.08, 9.07,    0,    0,    0,    0  ' 32
data 999, 1.03, 2.03, 5.07, 4.06,    0,    0,    0, 6.03, 7.05, 8.04  ' 33
data 999, 1.02, 4.01, 7.02, 7.05,    0,    0,    0, 3.03, 4.05,    0  ' 34
data 999, 3.06, 3.02,    0, 6.02, 6.01, 8.03, 7.07, 7.05,    0,    0  ' 35
data 999, 3.02, 2.04, 6.02,    0,    0, 7.05, 5.05,    0,    0,    0  ' 36
data 999,11.06,    0, 7.06,    0, 6.06, 6.09, 8.08,    0,    0,    0  ' 37
data 999, 5.06,    0,    0, 5.05,    0, 4.06, 8.08, 9.04, 9.06,    0  ' 38
data 999, 1.02, 4.02, 5.02, 5.01, 5.03, 4.04, 3.07, 7.06,    0,    0  ' 39
data 999,    0, 5.02, 8.02, 4.03, 3.05, 3.06, 4.07, 8.07,    0,    0  ' 40
data 999, 1.03, 6.02, 7.05, 8.06,    0,    0,    0, 2.03, 3.06, 5.06  ' 41
data 999, 3.01, 1.03,    0, 2.04, 7.03, 6.04, 6.05, 6.06, 6.07,    0  ' 42
data 999,    0, 2.05, 3.07, 4.03, 5.03, 6.03, 6.06, 5.08,    0,    0  ' 43
data 999, 7.03, 7.07, 7.09,    0,    0,    0,    0, 3.06, 3.08, 5.04  ' 44
data 999, 7.02, 6.03, 2.04, 1.05, 3.06, 4.07, 7.08, 2.09,    0,    0  ' 45
data 999, 3.03, 4.06, 4.07, 5.07, 5.08, 6.02, 6.03, 6.06, 7.05,    0  ' 46
data 999,    0, 2.05, 3.06, 4.04, 5.02, 5.03, 7.03, 7.06, 7.08,    0  ' 47
data 999, 1.02, 3.02,    0, 5.02, 5.06, 4.08, 2.07, 3.03,    0,    0  ' 48
data 999, 4.03, 9.03,    0,    0,10.04, 8.02, 4.08, 9.08, 9.07,    0  ' 49
data 999, 0.07, 2.07, 1.07, 1.09,11.07, 9.07,10.07, 8.02, 1.02, 1.04  ' 50
data 999,11.03,11.07, 7.02, 7.06, 6.07, 8.08,10.05,    0,    0,    0  ' 51
data 999,    0, 1.02, 1.03, 7.03, 6.05, 5.05, 5.04, 4.05, 3.08, 1.06  ' 52
data 999, 7.07, 6.04, 6.03, 2.04,    0,    0, 1.01, 1.08, 2.08, 5.07  ' 53
data 999,    0, 3.02, 5.02, 5.06, 4.07, 6.04, 8.03, 6.03, 9.05,    0  ' 54
data 999, 6.04,    0, 7.05, 7.04, 7.01, 9.02, 8.08, 5.05, 3.07, 4.01  ' 55
data 777

DefineFont #9
  0A303220
  00000000 00000000 00000000 00000000 00000000 00000000 00000000 00000000
  00000000 00000000 00000000 00000000 00000000 00000000 00000000 00000000
  00000000 00000000 00000000 00000000 00000000 00000000 00000000 00000000
  00000000 00000000 00000000 00000000 00000000 00000000 00000000 00000000
  00000000 00000000 00000000 00000000 00000000 00000000 00000000 00000000
  00000000 00000000 00000000 00000000 00000000 00000000 00000000 00000000
  00000000 00000000 0000F800 0000FC01 0000FE03 0000FE03 0000FE03 0000FF07
  0000FF07 0000FF07 0000FF07 0000FF07 0000FF07 0000FF07 0000FF07 0000FF07
  0000FF07 0000FF07 0000FF07 0000FF07 0000FF07 0000FE03 0000FE03 0000FE03
  0000FC01 0000FC01 0000FC01 0000F800 0000F800 00007000 00000000 00000000
  00007000 0000FC01 0000FE03 0000FE03 0000FF07 0000FF07 0000FF07 0000FE03
  0000FE03 0000FC01 00007000 00000000 00000000 00000000 00000000 00000000
  00000000 00000000 00000000 00000000 00FFFF3F E0FFFF3F F0FFFF3F F8FFFF3F
  F8FFFF3F F8FFFF3F FC03003F FC01003F FC00003F FC00003F FC00003F FC00003F
  FC00003F FC00003F FC01003F F803003F F807003F F0FFFF3F E0FFFF3F C0FFFF3F
  C0FFFF3F E0FFFF3F F0FFFF3F F807003F F803003F FC01003F FC00003F FC00003F
  FC00003F FC00003F FC00003F FC00003F FC00003F FC01003F FC03003F F8FFFF3F
  F8FFFF3F F8FFFF3F F0FFFF3F E0FFFF3F 00FFFF3F 00000000 00000000 00000000
  00000000 00000000 00000000 00000000 00000000 00000000 00FFFF00 E0FFFF07
  F0FFFF0F F8FFFF1F F8FFFF1F F8FFFF1F FC03C03F FC01803F FC00003F FC00003F
  0000003F 0000003F 0000003F 0000003F 0000003F 0000003F 0000003F 0000003F
  0000003F 0000003F 0000003F 0000003F 0000003F 0000003F 0000003F 0000003F
  0000003F 0000003F 0000003F 0000003F 0000003F FC00003F FC00003F FC01803F
  FC03C03F F8FFFF1F F8FFFF1F F8FFFF1F F0FFFF0F E0FFFF07 00FFFF00 00000000
  00000000 00000000 00000000 00000000 00000000 00000000 00000000 00000000
  00FFFF00 E0FFFF07 F0FFFF0F F8FFFF1F F8FFFF1F F8FFFF1F FC03C03F FC01803F
  FC00003F FC00003F FC00003F FC00003F FC00003F FC00003F FC00003F FC00003F
  FC00003F FC00003F FC00003F FC00003F FC00003F FC00003F FC00003F FC00003F
  FC00003F FC00003F FC00003F FC00003F FC00003F FC00003F FC00003F FC00003F
  FC00003F FC01803F FC03C03F F8FFFF1F F8FFFF1F F8FFFF1F F0FFFF0F E0FFFF07
  00FFFF00 00000000 00000000 00000000 00000000 00000000 00000000 00000000
  00000000 00000000 00000000 00000000 00000000 00000000 00000000 00000000
  00000000 00000000 00000000 00000000 00000000 00000000 00000000 FCF8FF00
  FCFCFF07 FCFEFF0F FCFFFF1F FCFFFF1F FCFFFF1F FC07C03F FC03803F FC01003F
  FC00003F FC00003F FC00003F FC00003F FC00003F FC00003F FC00003F FC00003F
  FC00003F FC00003F FC01003F FC03803F FC07C03F FCFFFF1F FCFFFF1F FCFFFF1F
  FCFEFF0F FCFCFF07 FCF8FF00 00000000 00000000 00000000 00000000 00000000
  00000000 00000000 00000000 00000000 00000000 00000000 00000000 00000000
  00000000 00000000 00000000 00000000 00000000 00000000 00000000 00000000
  00000000 00FFFF00 E0FFFF07 F0FFFF0F F8FFFF1F F8FFFF1F F8FFFF1F FC03C03F
  FC01803F FC00003F FC00003F FC00003F FCFFFF3F FCFFFF3F FCFFFF3F FCFFFF3F
  FCFFFF3F 0000003F 0000003F 0000003F 0000003F 0000803F FC03C03F FCFFFF1F
  FCFFFF1F F8FFFF1F F0FFFF0F E0FFFF07 00FFFF00 00000000 00000000 00000000
  00000000 00000000 00000000 00000000 00000000 00000000 00000000 0000F803
  0000F803 0000F803 0000F803 0000F803 0000F803 0000F803 0000F803 0000F803
  0000F803 0000F803 0000F803 0000F803 0000F803 FC01F803 FC01F803 FE01F803
  FE00F803 FF00F803 7F00F803 7F00F803 3F00F803 3F00F803 1F00F803 1F00F803
  0F00F803 0F00F803 0700F803 0700F803 0300F803 0300F803 0100F803 0100F803
  0000F803 0000F803 0000F803 0000FC03 0000FE03 0000FE01 0000FE00 00000000
  00000000 00000000 FF000000 FF000000 FF000000 FF000000 FF000000 FF000000
  00000000 00000000 00000000 00000000 00000000 00000000 00000000 00000000
  00000000 00000000 00000000 00000000 00000000 00000000 00000000 00FF1F3F
  E0FF3F3F F0FF7F3F F8FFFF3F F8FFFF3F F8FFFF3F FC03E03F FC01C03F FC00803F
  FC00003F FC00003F FC00003F FC00003F FC00003F FC00003F FC00003F FC00003F
  FC00003F FC00003F FC00003F FC00003F FC00003F FC00003F FC00003F FC00003F
  FC00003F 00000000 00000000 00000000 00000000 00000000 00000000 00000000
  00000000 00000000 00000000 00000000 00000000 00000000 00000000 00000000
  00000000 00000000 00000000 00000000 00000000 00000000 00000000 00000000
  00000000 00E00F00 00E00F00 00E00F00 00C01F00 00C01F00 00C01F00 00803F80
  00803F80 00803FC0 00007FC0 00007FE0 00007FE0 0000FEF0 0000FEF0 0000FEF8
  0000FCF9 0000FCFD 0000FCFD 0000F8FF 0000F8FF 0000F8FF 0000F07F 0000F07F
  0000F03F 0000E03F 0000E01F 0000E01F 0000C01F 0000C03F 0000C0FF 000080FF
  000080FF 000000FF 000000FE 000000F8
End DefineFont

DefineFont #10
  60201810
  00000000 00000000 00000000 00000000 00000000 00000000 00000000 00000000
  00000000 00000000 00000000 00000000 000E0000 001F001F 001F001F 001F001F
  001F001F 000E001F 000E000E 00000000 001F000E 000E001F 00000000 00000000
  300C0000 781E781E 781E781E 300C300C 00000000 00000000 00000000 00000000
  00000000 00000000 00000000 00000000 00000000 701C0000 701C701C FC7FFC7F
  701CFC7F 701C701C FC7F701C FC7FFC7F 701C701C 0000701C 00000000 00000000
  80038003 F81F8003 FE7FFC3F 0E701E78 807F0078 FC1FF03F 1E00FE03 1E780E70
  FC3FFE7F 8003F81F 80038003 00000000 1C7C1C38 386C386C 706C706C E038E07C
  C001C001 80038003 3E071C07 360E360E 361C361C 1C383E38 00000000 00000000
  C0030000 F81FF00F 3838783C F03C7838 C00FE01F CE1F860F FC78FE3D 78787870
  FE3FFC7C C60FEE1F 00000000 00000000 00030000 80078007 80078007 00030003
  00000000 00000000 00000000 00000000 00000000 00000000 00000000 00000000
  E003E000 E00FE007 000F800F 001F001F 001E001E 001E001E 001E001E 001F001E
  000F001F E00F800F E003E007 0000E000 C0070007 F007E007 F000F001 F800F800
  78007800 78007800 78007800 F8007800 F000F800 F007F001 C007E007 00000007
  00000000 C0038001 FC3FD81B F81FFC3F F00FE007 781E781E 0000300C 00000000
  00000000 00000000 00000000 00000000 00000000 00000000 C0030000 C003C003
  C003C003 FE7FFE7F FE7FFE7F C003C003 C003C003 0000C003 00000000 00000000
  00000000 00000000 00000000 00000000 00000000 00000000 00000000 001F000E
  001F001F 000E001F 0018001C 00000000 00000000 00000000 00000000 00000000
  00000000 FE7FFE7F FE7FFE7F 00000000 00000000 00000000 00000000 00000000
  00000000 00000000 00000000 00000000 00000000 00000000 00000000 001F000E
  001F001F 000E001F 00000000 00000000 07000700 1E000F00 3C001E00 78003800
  F000F000 C003E001 8007C003 000E000F 001C001E 0078003C 00F00078 00E000E0
  F81FE007 FC3FFC3F 3E7C7E7E 1E783E7C 1E781E78 1E781E78 3E7C1E78 7E7E3E7C
  FC3FFC3F E007F81F 00000000 00000000 F001F000 F007F003 F01FF00F F01CF03E
  F000F008 F000F000 F000F000 F000F000 F000F000 F000F000 00000000 00000000
  F81FE007 FE7FFC3F 1E703EF8 1E001E20 7C003E00 F007F801 001FC00F 007C003E
  FE7FFE7F FE7FFE7F 00000000 00000000 FE7FFE7F FE7FFE7F 7C003E00 F001F800
  F007E003 FE00FC03 1E003E00 3E7C1E78 FC3FFE7F E007F81F 00000000 00000000
  F8007800 F801F801 F807F803 780FF807 781E781E 7878783C FE7FFE7F FE7FFE7F
  78007800 78007800 00000000 00000000 FC3FFC3F FC3FFC3F 003C003C F03F003C
  FE3FFC3F 3E00FE3F 1E001E00 3E7C1E78 FC3FFE7F E007F81F 00000000 00000000
  F001F000 C007E003 001F800F 003E001E F87FE03F FE7FFC7F 1E783E7C 3E7C1E78
  FC3FFE7F E007F81F 00000000 00000000 FC7FFC7F FC7FFC7F 7C007C00 F800F800
  F001F001 E003E003 C007E007 800FC007 800F800F 800F800F 00000000 00000000
  F81FE007 FC3FFC3F 1E783E7C 3E7C1E78 F81FFC3F FE7FFC3F 1E783E7C 3E7C1E78
  FC3FFC3F E007F81F 00000000 00000000 F81FE007 FE7FFC3F 1E783E7C 3E7C1E78
  FE3FFE7F FE07FE1F 7C007C00 F801F800 E007F003 800FC00F 00000000 00000000
  00000000 00000000 00000000 001F000E 001F001F 000E001F 00000000 001F000E
  001F001F 000E001F 00000000 00000000 00000000 00000000 00000000 001F000E
  001F001F 000E001F 00000000 001F000E 001F001F 000E001F 0018001C 00000000
  00000000 18000800 78003800 F001F800 C007E003 001F800F C007800F F001E003
  7800F800 18003800 00000800 00000000 00000000 00000000 00000000 FC3F0000
  FC3FFC3F 0000FC3F FC3F0000 FC3FFC3F 0000FC3F 00000000 00000000 00000000
  00000000 00180010 001E001C 800F001F E003C007 F800F001 E003F001 800FC007
  001E001F 0018001C 00000010 00000000 F81FE007 FE3FFC3F 1E783E7C 3C001E78
  F8007C00 E003F001 C003C003 00000000 E007C003 C003E007 00000000 00000000
  00000000 E0070000 FC1FF80F 0E381C3C E667C673 766EF66F 766E766E FC67FE6F
  0238E073 1E1F063C F003FC0F 00000000 C003C003 E007C003 E007E007 F00FF00F
  781E700E 381C381C FC3F3C3C FE7FFC3F 1E78FE7F 1E781E78 00000000 00000000
  F87FE07F FC7FFC7F 1E703E70 3E701E70 F87FFC7F 3E70FC7F 1E701E70 3E701E70
  FC7FFE7F E07FF87F 00000000 00000000 F81FE007 FC3FFC3F 1E783E7C 00781E78
  00780078 00780078 1E780078 3E7C1E78 FC3FFE3F E007F81F 00000000 00000000
  F07FC07F FC7FF87F 1E783C78 0E781E78 0E780E78 0E780E78 1E780E78 3E781E78
  FC7FFC7F E07FF87F 00000000 00000000 FC7FFC7F FC7FFC7F 00700070 00700070
  F07FF07F F07FF07F 00700070 00700070 FC7FFC7F FC7FFC7F 00000000 00000000
  FC7FFC7F FC7FFC7F 00780078 00780078 F07FF07F F07FF07F 00780078 00780078
  00780078 00780078 00000000 00000000 F81FE007 FC3FFC3F 1E783E7C 00781E78
  00780078 FE78FE78 1E78FE78 3E7C1E78 FC3FFE3F E007F81F 00000000 00000000
  1E781E78 1E781E78 1E781E78 1E781E78 FE7FFE7F FE7FFE7F 1E781E78 1E781E78
  1E781E78 1E781E78 00000000 00000000 C003C003 C003C003 C003C003 C003C003
  C003C003 C003C003 C003C003 C003C003 C003C003 C003C003 00000000 00000000
  FE07FE07 3C00FE07 3C003C00 3C003C00 3C003C00 3C003C00 3C003C00 7C7C3C78
  F83FF83F C007F01F 00000000 00000000 3E781E78 F8787C78 E07BF079 807FC07F
  007E007F 807F007F E07BC07F F878F079 3E787C78 0E781E78 00000000 00000000
  00780078 00780078 00780078 00780078 00780078 00780078 00780078 00780078
  FC7FFC7F FC7FFC7F 00000000 00000000 0E700E70 1E781E78 3E7C3E7C 7E7E7E7E
  FE7FFE7F DE7BFE7F 9E79DE7B 1E789E79 1E781E78 1E781E78 00000000 00000000
  1E7C1E78 1E7E1E7C 1E7F1E7E 9E7F1E7F DE7F9E7F FE79FE7B FE78FE79 7E78FE78
  3E787E78 1E783E78 00000000 00000000 F81FE007 FC3FFC3F 1E783E7C 1E781E78
  1E781E78 1E781E78 1E781E78 3E7C1E78 FC3FFE3F E007F81F 00000000 00000000
  F87FE07F FC7FFC7F 1E783E78 1E781E78 3E781E78 FC7FFC7F E07FF87F 00780078
  00780078 00780078 00000000 00000000 F81FE007 FC3FFC3F 1E783E7C 1E781E78
  1E781E78 1E781E78 3C781E78 F87C3C78 FC3FF83F 8F07DF1F 00000000 00000000
  F87FE07F FC7FFC7F 1E783E78 1E781E78 3E781E78 FC7FFC7F E07FF87F F878F079
  3E787C78 1E781E78 00000000 00000000 F81FE007 FE3FFC3F 00783E7C 007C0078
  F83FE03F FC07FC1F 1E003E00 3E7C1E00 FC3FFE7F E007F81F 00000000 00000000
  FE7FFE7F FE7FFE7F C003C003 C003C003 C003C003 C003C003 C003C003 C003C003
  C003C003 C003C003 00000000 00000000 1E781E78 1E781E78 1E781E78 1E781E78
  1E781E78 1E781E78 1E781E78 3E7C1E78 FC3FFE3F E007F81F 00000000 00000000
  1E781E78 1E781E78 3C3C3C3C 3C3C3C3C 781E781E 781E781E F00F700E F00FF00F
  E007E007 E007E007 00000000 00000000 1EF01EF0 1EF01EF0 3EF91EF0 3C793C79
  BC7BBC7B F83FF83F F83EF83F F01EF01E 701C701C 701C701C 00000000 00000000
  1E781E78 3C3C1E78 781E3C3C F00F781E E007F00F F00FE007 F81FF00F 7C3E781E
  3E7C3C3C 1E781E78 00000000 00000000 1E781E78 3E7C1E78 3C3C3E7C 781E7C3E
  F00FF81F E007F00F C003E007 C003C003 C003C003 C003C003 00000000 00000000
  FE7FFE7F FE7FFE7F 7E003E00 F801FC00 E003F003 C00FE007 003F801F 007C007E
  FE7FFE7F FE7FFE7F 00000000 00000000 F01FF01F F01FF01F 001E001E 001E001E
  001E001E 001E001E 001E001E 001E001E 001E001E F01F001E F01FF01F 0000F01F
  00E000E0 007800F0 003C0078 001E001C 000F000F C0038007 E001C003 7000F000
  38007800 1E003C00 0F001E00 07000700 F80FF80F F80FF80F 78007800 78007800
  78007800 78007800 78007800 78007800 78007800 F80F7800 F80FF80F 0000F80F
  80030001 E00FC007 F83EF01F 38387C7C 00001010 00000000 00000000 00000000
  00000000 00000000 00000000 00000000 00000000 00000000 00000000 00000000
  00000000 00000000 00000000 00000000 00000000 FE7F0000 FE7FFE7F 0000FE7F
  000E0000 001F001F 001F001F 0007000E 00000003 00000000 00000000 00000000
  00000000 00000000 00000000 00000000 00000000 00000000 00000000 F81FE007
  7C7CFC3F FE071E30 FE7FFE3F 1E781E78 FE7F1E7C FE0FFE3F 00000000 00000000
  00780000 00780078 00780078 F87FE079 FC7FFC7F 1E783E7C 1E781E78 3E781E78
  FC7FFC7F E07FF87F 00000000 00000000 00000000 00000000 00000000 F81FE007
  FE3FFC3F 00781E7C 00780078 1E7C0078 FC3FFE3F E007F81F 00000000 00000000
  1E000000 1E001E00 1E001E00 FE1FFE07 FE3FFE3F 1E781E7C 1E781E78 1E7C1E78
  FE3FFE3F FE07FE1F 00000000 00000000 00000000 00000000 00000000 F81FE007
  3C3CFC3F FE7F1E78 0078FE7F 1E7C0078 FC3FFE3F E007F81F 00000000 00000000
  F8017800 F803F803 8007C007 FC7F8007 FC7FFC7F 8007FC7F 80078007 80078007
  80078007 80078007 00000000 00000000 00000000 00000000 00000000 FE1FDE07
  FE3FFE3F 1E783E7C 1E781E78 FE3F1E7C FE1FFE3F 3E00FE07 FC7F7C78 E00FF83F
  00780000 00780078 00780078 F87FE079 FC7FFC7F 3E7C7E7E 1E781E78 1E781E78
  1E781E78 1E781E78 00000000 00000000 C0078003 8003C007 00000000 C007C007
  C007C007 C007C007 C007C007 C007C007 C007C007 C007C007 00000000 00000000
  F001E000 E000F001 00000000 F001F001 F001F001 F001F001 F001F001 F001F001
  F001F001 F001F001 E07FE073 801FC03F 00780000 00780078 00780078 7C783E78
  F079F878 C07FE07B C07F807F F079E07F 7C78F878 1E783E78 00000000 00000000
  000F000F 000F000F 000F000F 000F000F 000F000F 000F000F 000F000F 000F000F
  800F000F C003C007 00000000 00000000 00000000 00000000 00000000 F8FE70EC
  FCFFFCFF DEF7FEFF 8EE38EE3 8EE38EE3 8EE38EE3 8EE38EE3 00000000 00000000
  00000000 00000000 00000000 F87FE079 FC7FFC7F 3E7C7E7E 1E781E78 1E781E78
  1E781E78 1E781E78 00000000 00000000 00000000 00000000 00000000 F81FE007
  FC3FFC3F 1E783E7C 1E781E78 3E7C1E78 FC3FFC3F E007F81F 00000000 00000000
  00000000 00000000 00000000 F87FE073 FC7FFC7F 1E783E7C 1E781E78 3E781E78
  FC7FFC7F E07FF87F 00780078 00780078 00000000 00000000 00000000 FC1F9C07
  FC3FFC3F 3C787C7C 3C783C78 3C7C3C78 F83FFC3F F807F81F 7E007800 7E007E00
  00000000 00000000 00000000 F87FE073 FC7FFC7F 1078387C 00780078 00780078
  00780078 00780078 00000000 00000000 00000000 00000000 00000000 F81FE007
  3C7CFC3F 003C0078 FC0FF81F 1E003E00 FC7F3E78 E00FF83F 00000000 00000000
  80070000 80078007 80078007 F03F8007 F03FF03F 8007F03F 80078007 80078007
  F807F007 F001F803 00000000 00000000 00000000 00000000 00000000 1E781E78
  1E781E78 1E781E78 1E781E78 7E7E3E7C FE3FFE3F 9E07FE1F 00000000 00000000
  00000000 00000000 00000000 1E781E78 1E781E78 1E781E78 3E7C1E78 F81F7C3E
  E007F00F 8001C003 00000000 00000000 00000000 00000000 00000000 07E007E0
  07E007E0 C7E387E1 FFFFEFF7 7E7EFE7F 3C3C3C3C 18181818 00000000 00000000
  00000000 00000000 00000000 3E7C1E78 781E7C3E E007F00F C003C003 F00FE007
  7C3E781E 1E783E7C 00000000 00000000 00000000 00000000 00000000 1E781E78
  3E7C1E78 7C3E3C3C F81F781E F00FF00F E007E007 C007C003 801F800F 0006000F
  00000000 00000000 00000000 FE7FFE7F FE7FFE7F F8017E00 C00FE007 007E803F
  FE7FFE7F FE7FFE7F 00000000 00000000 F801F800 C007F803 80078007 C001C003
  8007C003 003E001F 8007001F C0018003 C003C001 80078007 F803C007 F800F801
  C003C003 C003C003 C003C003 C003C003 C003C003 C003C003 C003C003 C003C003
  C003C003 C003C003 C003C003 C003C003 801F001F E003C01F E001E001 8003C003
  E001C003 7C00F800 E001F800 8003C001 C0038003 E001E001 C01FE003 001F801F
  00000000 00000000 00000000 00000000 0C1E0000 FC7FFC3F F060F87F 00000000
  00000000 00000000 00000000 00000000 A80A5005 AA2A5415 0A281554 02200550
  A2224551 A2224551 A2224551 02204551 0A280550 AA2A1554 A80A5415 00005005
End DefineFont
