' COBO  v1.3
' by vegipete  March, 2013
' for the Colour Maximite
Cls
Mode 4

'load support files
Sprite Load "balls.spr"
Font Load "bground.fnt" As #6
Open "levels.txt" For input As #1

Font #6
Print @(1,128) CLR$(Blue,Black) "2"
Print @(1, 96) CLR$(Green,Black) "3"
Print @(1, 64) CLR$(Green,Black) "4"
Print @(1, 32) CLR$(Green,Black) "5"
Print @(225,122) CLR$(Red) "<"
Print @(225, 90) CLR$(Red) "="
Print @(225, 58) CLR$(Red) ">"
Print @(225, 26) CLR$(Red) "?"
Font #2
Print @(90,5) CLR$(Yellow) "COBO";

'initialize variables
level = 0
lcode$ = ""
stepnum = 0
score = 0
cursor = 0
xsize = 12 : ysize = 10
maxballs = 10
xl = MM.HRes/2-16*xsize/2 : yt = MM.VRes/2-16*ysize/2
xr = MM.HRes/2+16*xsize/2 : yb = MM.VRes/2+16*ysize/2

Dim curlevel(maxballs,maxballs)

lcode$ = LoadNext$()
DrawLevel(0,level)

Do
  key = Asc(Inkey$)
  'check if a ball number was pressed
  If key >= 47 And key <= 57 Then
    If key = 48 Then key = 58  'change '0' to '10'
    'check if that ball is on screen
    If curlevel(stepnum,key-48) Then
      x = Int(curlevel(stepnum,key-48))
      y = Int(100*curlevel(stepnum,key-48) Mod 100)
      'if cursor is already on screen then move it
      If cursor Then
        Sprite move 1,xl+16*x,yt+16*y
        cursor = key-48
      'otherwise, turn on cursor
      Else
        Sprite on 1,xl+16*x,yt+16*y
        cursor = key-48
      EndIf
    Else
      'chose a non-existant ball
      If cursor Then cursor = 0 : Sprite off 1
    EndIf
  EndIf

  'check if arror key or space pressed, provided cursor is on a ball
  If cursor Then
    If key = 128 Then
      flick(cursor,0)   'up
      cursor = 0
    ElseIf key = 129 Then
      flick(cursor,1)   'down
      cursor = 0
    ElseIf key = 130 Then
      flick(cursor,2)   'left
      cursor = 0
    ElseIf key = 131 Then
      flick(cursor,3)   'right
      cursor = 0
    ElseIf key = 32 Then
      Sprite off 1      'space bar
      cursor = 0
    EndIf
  EndIf

  'undo a move? "Z" / "z"
  If key = 90 Or key = 122 Then
    If stepnum > 0 Then
      'erase cursor if visible
      If cursor Then cursor = 0 : Sprite off 1
      'find and erase any active sprites
      For i = 1 To maxballs
        If curlevel(stepnum,i) Then Sprite off i+1
      Next
      stepnum = stepnum - 1
      DrawLevel(stepnum,level)
    EndIf
  EndIf

'  'cheat to next level "n"
'  If key = 110 Then
'    'erase cursor if visible
'    If cursor Then cursor = 0 : Sprite off 1
'    'find and erase any active sprites
'    For i = 1 To maxballs
'      If curlevel(stepnum,i) Then Sprite off i+1
'    Next
'    level = level + 1
'    Line (xl+16,yt+60) - (xl+176,yt+104) , Black, BF
'    Print @(xl+47,yt+64) "Level";level;" Solved!"
'    Print @(xl+50,yt+76) "Code: ";lcode$
'    Print @(xl+20,yt+88) "Press SPACE to continue..."
'    Do
'    Loop Until Inkey$<>""
'    lcode$ = LoadNext$()
'    If lcode$ = "0" Then EndGame
'    DrawLevel(stepnum,level)
'  EndIf

  'restart level? "R" / "r"
  If key = 82 Or key = 114 Then
    'erase cursor if visible
    If cursor Then cursor = 0 : Sprite off 1
    'find and erase any active sprites
    For i = 1 To maxballs
      If curlevel(stepnum,i) Then Sprite off i+1
    Next
    stepnum = 0
    DrawLevel(stepnum,level)
  EndIf

  'enter a level code? "L" / "l"
  If key = 76 Or key = 108 Then
    'erase cursor if visible
    If cursor Then cursor = 0 : Sprite off 1
    'find and erase any active sprites
    For i = 1 To maxballs
      If curlevel(stepnum,i) Then Sprite off i+1
    Next
    Line (xl+16,yt+60) - (xl+176,yt+104) , Black, BF
    Print @(xl+47,yt+64) "Enter Level Code:"
    Print @(xl+50,yt+76) "";
    Input ">" ,userlev$
    FindLevel(level,userlev$)
    stepnum = 0
    DrawLevel(stepnum,level)
  EndIf

  'count remaining balls - level finished if only one left
  cnt = 0
  For i = 1 To maxballs
    If curlevel(stepnum,i) Then cnt = cnt + 1
  Next
  If cnt = 1 Then
    'find and erase remaining sprite
    For i = 1 To maxballs
      If curlevel(stepnum,i) Then Sprite off i+1
    Next

    level = level + 1
    Line (xl+16,yt+60) - (xl+176,yt+104) , Black, BF
    Print @(xl+47,yt+64) "Level";level;" Solved!"
    Print @(xl+50,yt+76) "Code: ";lcode$
    Print @(xl+20,yt+88) "Press SPACE to continue..."
    Do
    Loop Until Inkey$<>""

    lcode$ = LoadNext$()
    If lcode$ = "0" Then EndGame
    DrawLevel(stepnum,level)
  EndIf

Loop Until key = 27
Mode 3
End

'''''''''''''''''''''''''''''''''''''''''''''''
Sub EndGame
  Close #1    'end of level file so close it
  Line (xl+16,yt+60) - (xl+176,yt+104) , Black, BF
  Print @(65,100) "Congratulations!"
  Print @(40,112) "You've finished all levels!"
  Pause 2000
  Mode 3
  Print "Type RUN to play again."
  End
End Sub

'''''''''''''''''''''''''''''''''''''''''''''''
Sub Flick(bnum,dir)
  Local x,y,dx,dy

  Sprite off 1   'hide the cursor

  'set a new undo level
  For i = 1 To maxballs
    curlevel(stepnum+1,i) = curlevel(stepnum,i)
  Next i
  stepnum = stepnum + 1

  x = Int(curlevel(stepnum,bnum))
  y = Int(100*curlevel(stepnum,bnum) Mod 100)

  dx = 0 : dy = 0
  If dir = 0 Then dy = -1
  If dir = 1 Then dy =  1
  If dir = 2 Then dx = -1
  If dir = 3 Then dx =  1

  If notempty(x+dx,y+dy) Then
    wobble(bnum,x,y)
    stepnum = stepnum - 1   'invalid move so ignore new undo level
  Else
    moveball(bnum,dir)
  EndIf
End Sub

'''''''''''''''''''''''''''''''''''''''''''''''
'flick the given ball in the indicated direction
'update appropriately for valid move
Sub moveball(bnum,dir)
  Local x,y,dx,dy,sx,sy,mx,my
  Local i,clsn

  mx = Int(curlevel(stepnum,bnum))
  my = Int(100*curlevel(stepnum,bnum) Mod 100)  'cell coords
  dx = 0 : dy = 0
  If dir = 0 Then dy = -1
  If dir = 1 Then dy =  1
  If dir = 2 Then dx = -1
  If dir = 3 Then dx =  1
  i = 0 : clsn = 0
  sx = xl+16*mx : sy = yt+16*my   'starting x,y coords
  x = sx : y = sy                 'moving x,y coords
  Do
    x = x + dx : y = y + dy
    Sprite move bnum+1,x,y          'at least one cell is empty
    i = i + 1
    If i = 16 Then                'into next cell after 16 steps
      mx = mx + dx : my = my + dy
      i = notempty(mx+dx,my+dy)   'test next cell in direction of travel
      If i = -1 Then              'ball went off edge of field
        If clsn Then              'test if a collision has happened
          Sprite off bnum+1       'ball knocked off field - it's gone
          curlevel(stepnum,bnum) = 0 'mark ball as gone
          Exit Sub
        Else
          wobble(bnum,mx,my)      'no colision so illegal move
          Sprite move bnum+1,sx,sy  'move ball back to start
          stepnum = stepnum - 1   'invalid move so ignore new undo level
          Exit Sub
        EndIf
      ElseIf i Then               'ball hit another ball
        Tone 1600,1600,20
        clsn = 1
        curlevel(stepnum,bnum) = mx + my/100 'move ball to new spot
        bnum = i                  'now start moving ball that we hit
        mx = mx + dx : my = my + dy
        sx = xl+16*mx : sy = yt+16*my   'new ball's starting x,y coords
        x = sx : y = sy                 'new ball's moving x,y coords
        i = notempty(mx+dx,my+dy)   'test next cell in direction of travel
        Do While i > 0              'is there another ball in the way?
          Pause 5
          Tone stop
          Pause 5
          Tone 1600,1600,20
          bnum = i                  'shift to next ball
          mx = mx + dx : my = my + dy
          sx = xl+16*mx : sy = yt+16*my   'new ball's starting x,y coords
          x = sx : y = sy                 'new ball's moving x,y coords

          i = notempty(mx+dx,my+dy) 'test next cell in direction of travel
        Loop
      EndIf
      i = 0
    EndIf
    Pause 5
  Loop
End Sub

'''''''''''''''''''''''''''''''''''''''''''''''
'Test contents of (x,y)
'Return 0 if empty
'Return -1 if off field
'Return number of ball (1-maxballs) if position has a ball
Function notempty(x,y)
  Local n

  If x<0 Or x>xsize-1 Or y<0 Or y>ysize-1 Then notempty = -1 : Exit Function
  For n = 1 To maxballs
    If curlevel(stepnum,n) = x + y/100 Then
      notempty = n : Exit Function   'there's a ball in this spot
    EndIf
  Next n 'MUST SPECIFY VARIABLE HERE. WHY? BUG?
  notempty = 0
End Function

'''''''''''''''''''''''''''''''''''''''''''''''
'Wobble the specified sprite number back and forth at the given cell x,y
Sub wobble(num,x,y)
  Local i

  For i = 1 To 5
    Sprite move num+1,xl+16*x+2,yt+16*y
    Tone 220,220,10
    Pause 10
    Sprite move num+1,xl+16*x+4,yt+16*y
    Tone 180,180,10
    Pause 10
    Sprite move num+1,xl+16*x+2,yt+16*y
    Tone 220,220,10
    Pause 10
    Sprite move num+1,xl+16*x+0,yt+16*y
    Tone 280,280,10
    Pause 10
    Sprite move num+1,xl+16*x-2,yt+16*y
    Tone 220,220,10
    Pause 10
    Sprite move num+1,xl+16*x-4,yt+16*y
    Tone 180,180,10
    Pause 10
    Sprite move num+1,xl+16*x-2,yt+16*y
    Tone 220,220,10
    Pause 10
    Sprite move num+1,xl+16*x+0,yt+16*y
    Tone 280,280,10
    Pause 10
  Next
End Sub

'''''''''''''''''''''''''''''''''''''''''''''''
'try find a level with code given in flevel$
Sub FindLevel(clevel,flevel$)
  Local i
  Local newcode$

'  For i = 1 To maxballs
'    curlevel(1,i) = curlevel(0,i) 'preserve current level in case none found
'  Next
  Close #1                          'close levels
  Open "levels.txt" For input As #1 'and re-open at beginning

  i = -1
  Print @(xl+50,yt+89) "Searching...";

  Do
    newcode$ = LoadNext$() : i = i + 1
    Print @(xl+125,yt+89) i+1;" ";
    'test if code matches
    If newcode$ = flevel$ Then
      lcode$ = LoadNext$() 'load following level
      If lcode$ = "0" Then EndGame
      clevel = i + 1       'pass back level number found
      Exit Sub
    EndIf
    If newcode$ = "0" Then  'didn't find code so revert to previous level
      Close #1                          'close levels
      Open "levels.txt" For input As #1 'and re-open at beginning
      i = clevel
      Do While i >= 0
        newcode$ = LoadNext$() : i = i - 1
      Loop
      Exit Sub
    EndIf
  Loop

End Sub

'''''''''''''''''''''''''''''''''''''''''''''''
'change this to return level code or 0 if no more levels
Function LoadNext$
  Local fval
  Local letter$
  Local work$
  Local cr

  'find start of data stream
  letter$ = "    "
  Do
    letter$ = Right$(letter$ + Input$(1,#1),4)
    If letter$ = "DONE" Then
      LoadNext$ = "0"
      Exit Function
    EndIf
  Loop Until letter$ = "999,"

  'read location of each ball, store into array
  work$ = ""
  For i = 1 To maxballs
    letter$ = ""
    Do
      letter$ = letter$ + Input$(1,#1)
      cr = Asc(Right$(letter$,1))
      If cr > 48 And cr < 58 Then work$ = work$ + Chr$(cr)
    Loop Until Right$(letter$,1) = ","

    letter$ = Left$(letter$,Len(letter$)-1)   'chop off the comma
    fval = Val(letter$)
    curlevel(0,i) = fval
  Next
  work$ = Left$(work$+"12345678",8)
  stepnum = 0
  LoadNext$ = work$
End Function

'''''''''''''''''''''''''''''''''''''''''''''''
Sub DrawLevel(undo,lev)
  Local i,x,y

  'draw the background
  'Line (xl-8,yt-8) - (xr+8,yb+8) , Green, BF  'make a box around field
  Font #6
  For y = 0 To ysize/2 - 1
    For x = 0 To xsize/2 - 1
      Print @(xl+32*x,yt+32*y) CLR$(Green,Black) "1"
    Next
  Next
  Font #1

  Print @(xl,yt-12) "Level";lev+1;"  ";
  Print @(9,190) "Select ball number, Launch with arrow"
  Print @(19,202) "z = undo, r = restart, ESC to quit"

  'draw the balls
  For i = 1 To maxballs
    x = Int(curlevel(undo,i))
    y = Int(100*curlevel(undo,i) Mod 100)
    If (x <> 0) Or (y <> 0) Then Sprite on i+1,xl+16*x,yt+16*y
  Next
End Sub




